/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.ComparisonUtils;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            JsonArray allowedValues = (JsonArray)schema.getValue("enum");
            Set allowedValuesParsed = allowedValues.getList().stream().map(o -> o instanceof Map ? new JsonObject((Map)o) : (o instanceof List ? new JsonArray((List)o) : o)).collect(Collectors.toSet());
            return new EnumValidator(allowedValuesParsed);
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for enum keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null enum keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("enum");
    }

    public static class EnumValidator
    extends BaseSyncValidator {
        private final Object[] allowedValues;

        public EnumValidator(Set allowedValues) {
            this.allowedValues = allowedValues.toArray();
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.MAX_PRIORITY;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            for (Object allowedValue : this.allowedValues) {
                if (!ComparisonUtils.equalsNumberSafe(allowedValue, in)) continue;
                return;
            }
            throw ValidationException.create("Input doesn't match one of allowed values of enum: " + Arrays.toString(this.allowedValues), "enum", in);
        }
    }
}

