/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class FutureUtils {
    public static <T> Future<T> oneOf(List<Future<T>> results) {
        Promise res = Promise.promise();
        AtomicInteger processed = new AtomicInteger(0);
        AtomicBoolean atLeastOneOk = new AtomicBoolean(false);
        AtomicReference result = new AtomicReference();
        int len = results.size();
        for (Future<T> tFuture : results) {
            tFuture.onComplete(ar -> {
                int p = processed.incrementAndGet();
                if (ar.succeeded()) {
                    if (atLeastOneOk.get()) {
                        res.tryFail((Throwable)new IllegalStateException("One future was already completed"));
                    } else {
                        atLeastOneOk.set(true);
                        result.set(res.future().result());
                    }
                }
                if (p == len) {
                    if (atLeastOneOk.get()) {
                        res.tryComplete(result.get());
                    } else {
                        res.tryFail((Throwable)new IllegalStateException(ar.cause()));
                    }
                }
            });
        }
        return res.future();
    }
}

