/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.SchemaRepository;
import io.vertx.json.schema.Validator;
import io.vertx.json.schema.impl.BooleanSchema;
import io.vertx.json.schema.impl.Ref;
import io.vertx.json.schema.impl.SchemaValidatorImpl;
import io.vertx.json.schema.impl.URL;
import io.vertx.json.schema.impl.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaRepositoryImpl
implements SchemaRepository {
    private static final List<String> IGNORE_KEYWORD = Arrays.asList("id", "$id", "$ref", "$schema", "$anchor", "$vocabulary", "$comment", "default", "enum", "const", "required", "type", "maximum", "minimum", "exclusiveMaximum", "exclusiveMinimum", "multipleOf", "maxLength", "minLength", "pattern", "format", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties");
    private static final List<String> SCHEMA_ARRAY_KEYWORD = Arrays.asList("prefixItems", "items", "allOf", "anyOf", "oneOf");
    private static final List<String> SCHEMA_MAP_KEYWORD = Arrays.asList("$defs", "definitions", "properties", "patternProperties", "dependentSchemas");
    private static final List<String> SCHEMA_KEYWORD = Arrays.asList("additionalItems", "unevaluatedItems", "items", "contains", "additionalProperties", "unevaluatedProperties", "propertyNames", "not", "if", "then", "else");
    private final Map<String, JsonSchema> lookup = new HashMap<String, JsonSchema>();
    private final JsonSchemaOptions options;
    private final URL baseUri;

    public SchemaRepositoryImpl(JsonSchemaOptions options) {
        this.options = options;
        Objects.requireNonNull(options, "'options' cannot be null");
        Objects.requireNonNull(options.getBaseUri(), "'options.baseUri' cannot be null");
        this.baseUri = new URL(options.getBaseUri());
    }

    @Override
    public SchemaRepository dereference(JsonSchema schema) throws SchemaException {
        SchemaRepositoryImpl.dereference(this.lookup, schema, this.baseUri, "", true);
        return this;
    }

    @Override
    public SchemaRepository dereference(String uri, JsonSchema schema) throws SchemaException {
        SchemaRepositoryImpl.dereference(this.lookup, schema, new URL(uri, this.options.getBaseUri()), "", true);
        return this;
    }

    @Override
    public Validator validator(JsonSchema schema) {
        return new SchemaValidatorImpl(schema, this.options, Collections.unmodifiableMap(this.lookup));
    }

    @Override
    public Validator validator(String ref) {
        URL url = new URL(ref, this.baseUri);
        String uri = url.href();
        if (this.lookup.containsKey(uri)) {
            return new SchemaValidatorImpl(uri, this.options, Collections.unmodifiableMap(this.lookup));
        }
        throw new IllegalArgumentException("Unknown $ref: " + ref);
    }

    @Override
    public Validator validator(JsonSchema schema, JsonSchemaOptions options) {
        JsonSchemaOptions config = options.getBaseUri() == null ? new JsonSchemaOptions(options).setBaseUri(options.getBaseUri()) : options;
        return new SchemaValidatorImpl(schema, config, Collections.unmodifiableMap(this.lookup));
    }

    @Override
    public Validator validator(String ref, JsonSchemaOptions options) {
        JsonSchemaOptions config = options.getBaseUri() == null ? new JsonSchemaOptions(options).setBaseUri(options.getBaseUri()) : options;
        URL url = new URL(ref, this.baseUri);
        String uri = url.href();
        if (this.lookup.containsKey(uri)) {
            return new SchemaValidatorImpl(uri, config, Collections.unmodifiableMap(this.lookup));
        }
        throw new IllegalArgumentException("Unknown $ref: " + ref);
    }

    @Override
    public JsonObject resolve(JsonSchema schema) {
        HashMap<String, JsonSchema> lookup = new HashMap<String, JsonSchema>(Collections.unmodifiableMap(this.lookup));
        SchemaRepositoryImpl.dereference(lookup, schema, this.baseUri, "", true);
        return Ref.resolve(lookup, this.baseUri, schema);
    }

    @Override
    public JsonObject resolve(String ref) {
        URL url = new URL(ref, this.baseUri);
        String uri = url.href();
        if (this.lookup.containsKey(uri)) {
            return Ref.resolve(Collections.unmodifiableMap(this.lookup), this.baseUri, this.lookup.get(uri));
        }
        throw new IllegalArgumentException("Unknown $ref: " + ref);
    }

    @Override
    public JsonSchema find(String pointer) {
        URL url = new URL(pointer, this.baseUri);
        return this.lookup.get(url.href());
    }

    static void dereference(Map<String, JsonSchema> lookup, JsonSchema schema, URL baseURI, String basePointer, boolean schemaRoot) {
        String schemaURI;
        URL url;
        if (schema == null) {
            return;
        }
        if (!(schema instanceof BooleanSchema)) {
            String id;
            String string = id = schemaRoot ? (String)schema.get("$id", schema.get("id")) : null;
            if (Utils.Objects.truthy(id)) {
                url = new URL(id, baseURI.href());
                if (url.fragment().length() > 1) {
                    assert (!lookup.containsKey(url.href()));
                    lookup.put(url.href(), schema);
                } else {
                    url.anchor("");
                    if ("".equals(basePointer)) {
                        baseURI = url;
                    } else {
                        SchemaRepositoryImpl.dereference(lookup, schema, baseURI, "", schemaRoot);
                    }
                }
            }
        }
        if (lookup.containsKey(schemaURI = baseURI.href() + (Utils.Objects.truthy(basePointer) ? '#' + basePointer : ""))) {
            JsonSchema existing = lookup.get(schemaURI);
            if (existing.equals(schema)) {
                return;
            }
            throw new SchemaException(schema, "Duplicate schema URI \"" + schemaURI + "\".");
        }
        lookup.put(schemaURI, schema);
        if (schema instanceof BooleanSchema) {
            return;
        }
        if (!schema.containsKey("__absolute_uri__")) {
            schema.annotate("__absolute_uri__", schemaURI);
        }
        if (schema.containsKey("$ref") && !schema.containsKey("__absolute_ref__")) {
            url = new URL((String)schema.get("$ref"), baseURI.href());
            url.anchor(url.fragment());
            schema.annotate("__absolute_ref__", url.href());
        }
        if (schema.containsKey("$recursiveRef") && !schema.containsKey("__absolute_recursive_ref__")) {
            url = new URL((String)schema.get("$recursiveRef"), baseURI.href());
            url.anchor(url.fragment());
            schema.annotate("__absolute_recursive_ref__", url.href());
        }
        if (schema.containsKey("$anchor")) {
            url = new URL("#" + (String)schema.get("$anchor"), baseURI);
            assert (!lookup.containsKey(url.href()));
            lookup.put(url.href(), schema);
        }
        for (String key : schema.fieldNames()) {
            if (IGNORE_KEYWORD.contains(key)) continue;
            String keyBase = basePointer + "/" + Utils.Pointers.encode(key);
            Object subSchema = schema.get(key);
            if (subSchema instanceof JsonArray) {
                if (!SCHEMA_ARRAY_KEYWORD.contains(key)) continue;
                for (int i = 0; i < ((JsonArray)subSchema).size(); ++i) {
                    SchemaRepositoryImpl.dereference(lookup, Utils.Schemas.wrap((JsonArray)subSchema, i), baseURI, keyBase + "/" + i, false);
                }
                continue;
            }
            if (SCHEMA_MAP_KEYWORD.contains(key)) {
                for (String subKey : ((JsonObject)subSchema).fieldNames()) {
                    SchemaRepositoryImpl.dereference(lookup, Utils.Schemas.wrap((JsonObject)subSchema, subKey), baseURI, keyBase + "/" + Utils.Pointers.encode(subKey), true);
                }
                continue;
            }
            if (subSchema instanceof Boolean) {
                SchemaRepositoryImpl.dereference(lookup, JsonSchema.of((Boolean)subSchema), baseURI, keyBase, SCHEMA_KEYWORD.contains(key));
                continue;
            }
            if (!(subSchema instanceof JsonObject)) continue;
            SchemaRepositoryImpl.dereference(lookup, JsonSchema.of((JsonObject)subSchema), baseURI, keyBase, SCHEMA_KEYWORD.contains(key));
        }
    }
}

