/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.openapi.ErrorType;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.RouterBuilderException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ContractEndpointHandler
implements Handler<RoutingContext> {
    private static final List<MIMEHeader> JSON_DATA_TYPES = Stream.of(new ParsableMIMEValue("application/json").forceParse()).collect(Collectors.toList());
    private final Buffer openapiJson;
    private final Buffer openapiYaml;

    private ContractEndpointHandler(Buffer openapiJson, Buffer openapiYaml) {
        this.openapiJson = openapiJson;
        this.openapiYaml = openapiYaml;
    }

    public void handle(RoutingContext context) {
        if (this.responseAsJson(context)) {
            context.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(this.openapiJson);
            return;
        }
        context.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/yaml").end(this.openapiYaml);
    }

    public boolean responseAsJson(RoutingContext context) {
        MIMEHeader acceptJsonHeader = context.parsedHeaders().findBestUserAcceptedIn(context.parsedHeaders().accept(), JSON_DATA_TYPES);
        if (acceptJsonHeader != null) {
            return true;
        }
        String format = context.queryParams().get("format");
        return format != null && format.equalsIgnoreCase("json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContractEndpointHandler create(OpenAPIHolder holder) {
        try (StringWriter writer = new StringWriter();){
            JsonObject openapi = holder.getOpenAPI();
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
            yaml.dump((Object)openapi.getMap(), (Writer)writer);
            ContractEndpointHandler contractEndpointHandler = new ContractEndpointHandler(openapi.toBuffer(), Buffer.buffer((String)writer.toString()));
            return contractEndpointHandler;
        }
        catch (IOException | RuntimeException e) {
            throw new RouterBuilderException("Cannot generate yaml contract", ErrorType.UNSUPPORTED_SPEC, e);
        }
    }
}

