/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.openapi.OpenAPIHolder;
import io.vertx.ext.web.openapi.RouterBuilderException;
import io.vertx.ext.web.openapi.impl.OpenAPI3Utils;
import io.vertx.ext.web.openapi.impl.RegexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OpenAPI3PathResolver {
    final String oasPath;
    final List<JsonObject> parameters;
    final OpenAPIHolder openAPIHolder;
    Pattern resolvedPattern;
    Map<String, String> mappedGroups;
    public static final Pattern OAS_PATH_PARAMETERS_PATTERN = Pattern.compile("\\{{1}[.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*\\}{1}");
    public static final Pattern ILLEGAL_PATH_MATCHER = Pattern.compile("\\{[^\\/]*\\/[^\\/]*\\}");
    private boolean shouldThreatDotAsReserved;

    public OpenAPI3PathResolver(String oasPath, List<JsonObject> parameters, OpenAPIHolder openAPIHolder) {
        this.oasPath = oasPath;
        this.parameters = parameters != null ? parameters.stream().filter(parameter -> parameter.getString("in").equals("path")).collect(Collectors.toList()) : new ArrayList<JsonObject>();
        this.openAPIHolder = openAPIHolder;
        this.shouldThreatDotAsReserved = this.hasParameterWithStyle("label");
        this.mappedGroups = new HashMap<String, String>();
    }

    public Optional<Pattern> solve() {
        if (ILLEGAL_PATH_MATCHER.matcher(this.oasPath).matches()) {
            throw RouterBuilderException.createUnsupportedSpecFeature("Path template not supported");
        }
        Matcher parametersMatcher = OAS_PATH_PARAMETERS_PATTERN.matcher(this.oasPath);
        if (!this.parameters.isEmpty() && parametersMatcher.find()) {
            StringBuilder regex = new StringBuilder();
            int lastMatchEnd = 0;
            boolean endSlash = this.oasPath.charAt(this.oasPath.length() - 1) == '/';
            parametersMatcher.reset();
            int i = 0;
            while (parametersMatcher.find()) {
                String toQuote = this.oasPath.substring(lastMatchEnd, parametersMatcher.start());
                if (toQuote.length() != 0) {
                    regex.append(Pattern.quote(toQuote));
                }
                lastMatchEnd = parametersMatcher.end();
                String paramName = parametersMatcher.group(1);
                Optional<JsonObject> parameterOptional = this.parameters.stream().filter(p -> p.getString("name").equals(paramName)).findFirst();
                if (parameterOptional.isPresent()) {
                    ArrayList<RegexBuilder> regexBuilders;
                    Map<String, JsonObject> properties;
                    JsonObject parameter = parameterOptional.get();
                    JsonObject fakeSchema = OpenAPI3Utils.generateFakeSchema(parameter.getJsonObject("schema", new JsonObject()), this.openAPIHolder);
                    String style = parameter.getString("style", "simple");
                    boolean explode = parameter.getBoolean("explode", Boolean.valueOf(false));
                    boolean isObject = OpenAPI3Utils.isSchemaObjectOrCombinators(fakeSchema);
                    boolean isArray = OpenAPI3Utils.isSchemaArray(fakeSchema);
                    String groupName = "p" + i;
                    if (style.equals("simple")) {
                        regex.append(RegexBuilder.create().namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "+", "$", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).zeroOrOne());
                        this.mappedGroups.put(groupName, paramName);
                    } else if (style.equals("label")) {
                        if (isObject && explode) {
                            properties = OpenAPI3Utils.solveObjectParameters(fakeSchema);
                            regexBuilders = new ArrayList<RegexBuilder>();
                            for (Map.Entry<String, JsonObject> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regexBuilders.add(RegexBuilder.create().group(RegexBuilder.create().escapeCharacter(".").zeroOrOne().quote(entry.getKey()).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "+", "$", "/", "?", "#", "[", "]", ".", "=").zeroOrMore())));
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                            regex.append(RegexBuilder.create().anyOfGroup(properties.size(), regexBuilders.stream()));
                        } else {
                            regex.append(RegexBuilder.create().escapeCharacter(".").zeroOrOne().namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]").zeroOrMore()).zeroOrOne());
                            this.mappedGroups.put(groupName, paramName);
                        }
                    } else if (style.equals("matrix")) {
                        if (isObject && explode) {
                            properties = OpenAPI3Utils.solveObjectParameters(fakeSchema);
                            regexBuilders = new ArrayList();
                            for (Map.Entry<String, JsonObject> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regexBuilders.add(RegexBuilder.create().group(RegexBuilder.create().escapeCharacter(";").quote(entry.getKey()).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore())));
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                            regex.append(RegexBuilder.create().anyOfGroup(properties.size(), regexBuilders.stream()));
                        } else if (isArray && explode) {
                            regex.append(RegexBuilder.create().namedGroup(groupName, RegexBuilder.create().atomicGroup(RegexBuilder.create().append(";").quote(paramName).append("=").notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", ",", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).oneOrMore()));
                            this.mappedGroups.put(groupName, paramName);
                        } else {
                            regex.append(RegexBuilder.create().append(";").quote(paramName).append("=").namedGroup(groupName, RegexBuilder.create().notCharactersClass("!", "*", "'", "(", ")", ";", "@", "&", "=", "+", "$", "/", "?", "#", "[", "]", this.shouldThreatDotAsReserved ? "." : null).zeroOrMore()).zeroOrOne());
                            this.mappedGroups.put(groupName, paramName);
                        }
                    }
                } else {
                    throw RouterBuilderException.createInvalidSpec("Missing parameter definition for parameter name: " + paramName, null);
                }
                ++i;
            }
            String toAppendQuoted = this.oasPath.substring(lastMatchEnd, endSlash ? this.oasPath.length() - 1 : this.oasPath.length());
            if (toAppendQuoted.length() != 0) {
                regex.append(Pattern.quote(toAppendQuoted));
            }
            if (endSlash) {
                regex.append("\\/");
            }
            return Optional.of(Pattern.compile(regex.toString()));
        }
        return Optional.empty();
    }

    public Pattern getResolvedPattern() {
        return this.resolvedPattern;
    }

    public Map<String, String> getMappedGroups() {
        return this.mappedGroups;
    }

    private boolean hasParameterWithStyle(String style) {
        return this.parameters.stream().map(p -> p.getString("style", "simple")).anyMatch(s -> s.equals(style));
    }

    private boolean hasParameterWithStyleAndExplode(String style, boolean explode) {
        return this.parameters.stream().anyMatch(p -> p.getString("style", "simple").equals(style) && p.getBoolean("explode", Boolean.valueOf(false)) == explode);
    }
}

