@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  neonbee-core startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and NEONBEE_CORE_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\neonbee-core-0.16.1.jar;%APP_HOME%\lib\vertx-web-openapi-4.3.4.jar;%APP_HOME%\lib\vertx-health-check-4.3.4.jar;%APP_HOME%\lib\vertx-web-validation-4.3.4.jar;%APP_HOME%\lib\vertx-web-4.3.4.jar;%APP_HOME%\lib\vertx-web-client-4.3.4.jar;%APP_HOME%\lib\vertx-config-yaml-4.3.4.jar;%APP_HOME%\lib\vertx-config-4.3.4.jar;%APP_HOME%\lib\vertx-micrometer-metrics-4.3.4.jar;%APP_HOME%\lib\vertx-auth-htpasswd-4.3.4.jar;%APP_HOME%\lib\vertx-auth-htdigest-4.3.4.jar;%APP_HOME%\lib\vertx-auth-jwt-4.3.4.jar;%APP_HOME%\lib\vertx-auth-oauth2-4.3.4.jar;%APP_HOME%\lib\vertx-auth-common-4.3.4.jar;%APP_HOME%\lib\vertx-hazelcast-4.3.4.jar;%APP_HOME%\lib\vertx-infinispan-4.3.4.jar;%APP_HOME%\lib\vertx-web-common-4.3.4.jar;%APP_HOME%\lib\vertx-bridge-common-4.3.4.jar;%APP_HOME%\lib\vertx-uri-template-4.3.4.jar;%APP_HOME%\lib\vertx-json-schema-4.3.4.jar;%APP_HOME%\lib\vertx-core-4.3.4.jar;%APP_HOME%\lib\cds4j-core-1.30.0.jar;%APP_HOME%\lib\odata-server-core-ext-4.9.0.jar;%APP_HOME%\lib\odata-server-core-4.9.0.jar;%APP_HOME%\lib\jackson-databind-2.13.4.jar;%APP_HOME%\lib\jackson-core-2.13.4.jar;%APP_HOME%\lib\jackson-annotations-2.13.4.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.13.4.jar;%APP_HOME%\lib\micrometer-registry-prometheus-1.9.2.jar;%APP_HOME%\lib\asm-9.3.jar;%APP_HOME%\lib\logback-classic-1.2.11.jar;%APP_HOME%\lib\slf4j-api-1.7.36.jar;%APP_HOME%\lib\guava-31.1-jre.jar;%APP_HOME%\lib\spotbugs-annotations-4.7.1.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.82.Final.jar;%APP_HOME%\lib\netty-codec-http2-4.1.82.Final.jar;%APP_HOME%\lib\odata-server-api-4.9.0.jar;%APP_HOME%\lib\netty-codec-http-4.1.82.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.82.Final.jar;%APP_HOME%\lib\netty-handler-4.1.82.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.82.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.82.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.82.Final.jar;%APP_HOME%\lib\netty-codec-4.1.82.Final.jar;%APP_HOME%\lib\netty-transport-4.1.82.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.82.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.82.Final.jar;%APP_HOME%\lib\netty-common-4.1.82.Final.jar;%APP_HOME%\lib\snakeyaml-1.32.jar;%APP_HOME%\lib\micrometer-core-1.9.4.jar;%APP_HOME%\lib\HdrHistogram-2.1.12.jar;%APP_HOME%\lib\odata-commons-core-4.9.0.jar;%APP_HOME%\lib\commons-codec-1.15.jar;%APP_HOME%\lib\hazelcast-4.2.2.jar;%APP_HOME%\lib\infinispan-multimap-13.0.10.Final.jar;%APP_HOME%\lib\infinispan-clustered-lock-13.0.10.Final.jar;%APP_HOME%\lib\infinispan-clustered-counter-13.0.10.Final.jar;%APP_HOME%\lib\infinispan-core-13.0.10.Final.jar;%APP_HOME%\lib\wildfly-common-1.5.1.Final.jar;%APP_HOME%\lib\caffeine-2.8.4.jar;%APP_HOME%\lib\rxjava-3.0.13.jar;%APP_HOME%\lib\reactive-streams-1.0.3.jar;%APP_HOME%\lib\commons-io-2.11.0.jar;%APP_HOME%\lib\cds4j-api-1.30.0.jar;%APP_HOME%\lib\simpleclient_common-0.15.0.jar;%APP_HOME%\lib\logback-core-1.2.11.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-3.12.0.jar;%APP_HOME%\lib\error_prone_annotations-2.11.0.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\LatencyUtils-2.0.3.jar;%APP_HOME%\lib\infinispan-commons-13.0.10.Final.jar;%APP_HOME%\lib\protostream-types-4.4.3.Final.jar;%APP_HOME%\lib\protostream-4.4.3.Final.jar;%APP_HOME%\lib\jgroups-4.2.18.Final.jar;%APP_HOME%\lib\jakarta.transaction-api-1.3.3.jar;%APP_HOME%\lib\jboss-threads-2.3.3.Final.jar;%APP_HOME%\lib\jboss-logging-3.4.3.Final.jar;%APP_HOME%\lib\odata-commons-api-4.9.0.jar;%APP_HOME%\lib\simpleclient-0.15.0.jar;%APP_HOME%\lib\simpleclient_tracer_otel-0.15.0.jar;%APP_HOME%\lib\simpleclient_tracer_otel_agent-0.15.0.jar;%APP_HOME%\lib\simpleclient_tracer_common-0.15.0.jar


@rem Execute neonbee-core
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %NEONBEE_CORE_OPTS%  -classpath "%CLASSPATH%" io.neonbee.Launcher %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable NEONBEE_CORE_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%NEONBEE_CORE_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
