/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.utils.ClassUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class AsmHelper {
    private static final List<Character> PRIMITIVE_TYPE_NAMES = new ArrayList<Character>(Arrays.asList(Character.valueOf('V'), Character.valueOf('Z'), Character.valueOf('C'), Character.valueOf('B'), Character.valueOf('S'), Character.valueOf('I'), Character.valueOf('F'), Character.valueOf('J'), Character.valueOf('D')));

    public static Optional<MethodNode> getMethodNode(MethodInsnNode methodInsn, ClassNode owner) {
        return owner.methods.stream().filter(m -> m.desc.equals(methodInsn.desc) && m.name.equals(methodInsn.name)).findFirst();
    }

    public static ClassNode getAsmClassForInternalName(String internalName, ClassLoader classLoader) throws IOException {
        return AsmHelper.getAsmClass(Type.getObjectType((String)internalName).getClassName(), classLoader);
    }

    public static ClassNode getAsmClassForDescriptor(String descriptor, ClassLoader classLoader) throws IOException {
        return AsmHelper.getAsmClass(Type.getType((String)descriptor).getClassName(), classLoader);
    }

    public static ClassNode getAsmClass(String fullyQualifiedClassName, ClassLoader classLoader) throws IOException {
        if (classLoader != null) {
            return AsmHelper.getAsmClass(ClassUtils.getClassInputStreamForClassName((String)fullyQualifiedClassName, (ClassLoader)classLoader));
        }
        return AsmHelper.getAsmClass(ClassUtils.getClassInputStreamForClassName((String)fullyQualifiedClassName, (ClassLoader)AsmHelper.class.getClassLoader()));
    }

    public static ClassNode getAsmClass(InputStream classStream) throws IOException {
        ClassReader classReader = new ClassReader(classStream);
        ClassNode asmClass = new ClassNode();
        classReader.accept((ClassVisitor)asmClass, 0);
        return asmClass;
    }

    public static boolean hasAnnotations(MethodNode asmMethod, Class<?> ... annotations) {
        return AsmHelper.hasAnnotation(asmMethod.invisibleAnnotations, annotations);
    }

    public static boolean hasAnnotations(ClassNode asmClass, Class<?> ... annotations) {
        return AsmHelper.hasAnnotation(asmClass.invisibleAnnotations, annotations);
    }

    private static boolean hasAnnotation(List<AnnotationNode> annotations, Class<?> ... annotationTypes) {
        if (annotationTypes.length == 0) {
            throw new IllegalArgumentException("Provide at least one annotation class.");
        }
        List descriptors = Stream.of(annotationTypes).map(Type::getDescriptor).collect(Collectors.toList());
        return annotations != null && annotations.stream().anyMatch(annotation -> descriptors.stream().anyMatch(desc -> annotation.desc.equals(desc)));
    }

    public static Optional<AnnotationNode> getAnnotationNode(FieldNode fieldNode, Class<?> annotation) {
        return AsmHelper.getAnnotationNode(fieldNode.invisibleAnnotations, annotation);
    }

    public static Optional<AnnotationNode> getAnnotationNode(MethodNode methodNode, Class<?> annotation) {
        return AsmHelper.getAnnotationNode(methodNode.invisibleAnnotations, annotation);
    }

    public static Optional<AnnotationNode> getAnnotationNode(ClassNode fieldNode, Class<?> annotation) {
        return AsmHelper.getAnnotationNode(fieldNode.invisibleAnnotations, annotation);
    }

    private static Optional<AnnotationNode> getAnnotationNode(List<AnnotationNode> annotationNodes, Class<?> annotation) {
        if (annotationNodes == null) {
            return Optional.empty();
        }
        return annotationNodes.stream().filter(a -> a.desc.equals(Type.getDescriptor((Class)annotation))).findFirst();
    }

    public static void printJVMInstructions(String fullyQualifiedClassName) throws IOException {
        InputStream in = AsmHelper.class.getClassLoader().getResourceAsStream(fullyQualifiedClassName.replace('.', '/') + ".class");
        if (in == null) {
            throw new IllegalArgumentException(String.format("Couldn't find .class file for %s.", fullyQualifiedClassName));
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(in);){
            ((InputStream)bufferedInputStream).mark(0);
            AsmHelper.printJVMInstructions(bufferedInputStream);
            ((InputStream)bufferedInputStream).reset();
        }
    }

    public static void printJVMInstructions(InputStream in) throws IOException {
        ClassReader reader = new ClassReader(in);
        ClassNode classNode = new ClassNode();
        Textifier printer = new Textifier();
        TraceMethodVisitor methodVisitor = new TraceMethodVisitor((Printer)printer);
        reader.accept((ClassVisitor)classNode, 2);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            InsnList inList = m.instructions;
            System.out.println(m.name);
            for (int i = 0; i < inList.size(); ++i) {
                System.out.print(AsmHelper.insnToString(inList.get(i), methodVisitor, (Printer)printer));
                printer.getText().clear();
            }
        }
    }

    private static String insnToString(AbstractInsnNode insn, TraceMethodVisitor methodVisitor, Printer printer) {
        insn.accept((MethodVisitor)methodVisitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        return sw.toString();
    }

    public static int getFieldIndex(FieldInsnNode fieldInsn, ClassNode owner) {
        int idx = 0;
        for (FieldNode field : owner.fields) {
            if (field.name.equals(fieldInsn.name)) break;
            ++idx;
        }
        return idx;
    }

    public static int getFieldIndex(FieldInsnNode fieldInsn, CompilationUnit compUnit) throws IOException {
        return AsmHelper.getFieldIndex(fieldInsn, AsmHelper.getAsmClassForInternalName(fieldInsn.owner, compUnit.getClassLoader()));
    }

    public static List<String> extractTypeParametersFromSignature(FieldNode fieldNode) {
        String sig = fieldNode.signature;
        if (!sig.contains("<")) {
            return new ArrayList<String>();
        }
        int startIdx = sig.indexOf("<") + 1;
        int endIdx = sig.lastIndexOf(">");
        String typesString = sig.substring(startIdx, endIdx);
        return AsmHelper.extractTypeParamsFromString(typesString);
    }

    private static List<String> extractTypeParamsFromString(String types) {
        types = types.replaceAll("<[^<>]*>", "");
        ArrayList<String> separatedTypes = new ArrayList<String>();
        int i = 0;
        while (i < types.length()) {
            if (types.charAt(i) == '[' && PRIMITIVE_TYPE_NAMES.contains(Character.valueOf(types.charAt(i + 1)))) {
                separatedTypes.add(Character.toString(types.charAt(i++)) + types.charAt(i++));
                continue;
            }
            String t = types.substring(i, types.indexOf(";", i) + 1);
            separatedTypes.add(t);
            i += t.length();
        }
        return separatedTypes;
    }

    public static String getInternalNameForDescriptor(String descriptor) {
        return Type.getType((String)descriptor).getInternalName();
    }
}

