/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.DebugInfo;
import io.neow3j.compiler.InitsslotNeoMethod;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.ManifestBuilder;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.compiler.converters.ConverterMap;
import io.neow3j.compiler.sourcelookup.ISourceContainer;
import io.neow3j.contract.NefFile;
import io.neow3j.devpack.ByteString;
import io.neow3j.devpack.ECPoint;
import io.neow3j.devpack.Hash160;
import io.neow3j.devpack.Hash256;
import io.neow3j.devpack.InteropInterface;
import io.neow3j.devpack.Iterator;
import io.neow3j.devpack.Map;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.devpack.annotations.Syscall;
import io.neow3j.devpack.events.EventInterface;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.script.InteropService;
import io.neow3j.script.OpCode;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.types.ContractParameterType;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Compiler {
    public static final String COMPILER_NAME = "neow3j-3.11.2";
    public static final int MAX_PARAMS_COUNT = 255;
    public static final int MAX_LOCAL_VARIABLES = 255;
    public static final int MAX_STATIC_FIELDS = 255;
    public static final String INSTANCE_CTOR = "<init>";
    private static final String CLASS_CTOR = "<clinit>";
    public static final String THIS_KEYWORD = "this";
    public static final String INSTRUCTION_ANNOTATION_OPERAND = "operand";
    public static final String INSTRUCTION_ANNOTATION_OPERAND_PREFIX = "operandPrefix";
    private final CompilationUnit compUnit;

    public Compiler() {
        this.compUnit = new CompilationUnit(this.getClass().getClassLoader());
    }

    public Compiler(ClassLoader classLoader) {
        this.compUnit = new CompilationUnit(classLoader);
    }

    public static ContractParameterType mapTypeToParameterType(Type type) {
        Class<?> clazz2;
        String typeName = type.getClassName();
        if (typeName.equals(String.class.getTypeName())) {
            return ContractParameterType.STRING;
        }
        if (typeName.equals(Integer.class.getTypeName()) || typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName()) || typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Byte.class.getTypeName()) || typeName.equals(Byte.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Character.class.getTypeName()) || typeName.equals(Character.TYPE.getTypeName())) {
            return ContractParameterType.INTEGER;
        }
        if (typeName.equals(Boolean.class.getTypeName()) || typeName.equals(Boolean.TYPE.getTypeName())) {
            return ContractParameterType.BOOLEAN;
        }
        if (typeName.equals(Byte[].class.getTypeName()) || typeName.equals(byte[].class.getTypeName()) || typeName.equals(ByteString.class.getTypeName())) {
            return ContractParameterType.BYTE_ARRAY;
        }
        if (typeName.equals(Void.class.getTypeName()) || typeName.equals(Void.TYPE.getTypeName())) {
            return ContractParameterType.VOID;
        }
        if (typeName.equals(ECPoint.class.getTypeName())) {
            return ContractParameterType.PUBLIC_KEY;
        }
        if (typeName.equals(Map.class.getTypeName())) {
            return ContractParameterType.MAP;
        }
        if (typeName.equals(Hash160.class.getTypeName())) {
            return ContractParameterType.HASH160;
        }
        if (typeName.equals(Hash256.class.getTypeName())) {
            return ContractParameterType.HASH256;
        }
        if (typeName.equals(io.neow3j.devpack.List.class.getTypeName()) || typeName.equals(Iterator.Struct.class.getTypeName())) {
            return ContractParameterType.ARRAY;
        }
        try {
            typeName = ClassUtils.getFullyQualifiedNameForInternalName((String)type.getInternalName());
            clazz2 = Class.forName(typeName);
            if (Arrays.asList(clazz2.getInterfaces()).contains(InteropInterface.class)) {
                return ContractParameterType.INTEROP_INTERFACE;
            }
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            typeName = type.getDescriptor().replace("/", ".");
            clazz2 = Class.forName(typeName);
            if (clazz2.isArray()) {
                return ContractParameterType.ARRAY;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ContractParameterType.ANY;
    }

    public static StackItemType mapTypeToStackItemType(Type type) {
        String typeName = type.getClassName();
        if (typeName.equals(String.class.getTypeName()) || typeName.equals(Hash160.class.getTypeName()) || typeName.equals(Hash256.class.getTypeName()) || typeName.equals(ECPoint.class.getTypeName()) || typeName.equals(ByteString.class.getTypeName())) {
            return StackItemType.BYTE_STRING;
        }
        if (typeName.equals(Integer.class.getTypeName()) || typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName()) || typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Byte.class.getTypeName()) || typeName.equals(Byte.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Character.class.getTypeName()) || typeName.equals(Character.TYPE.getTypeName())) {
            return StackItemType.INTEGER;
        }
        if (typeName.equals(Boolean.class.getTypeName()) || typeName.equals(Boolean.TYPE.getTypeName())) {
            return StackItemType.BOOLEAN;
        }
        if (typeName.equals(Byte[].class.getTypeName()) || typeName.equals(byte[].class.getTypeName())) {
            return StackItemType.BUFFER;
        }
        if (typeName.equals(Map.class.getTypeName())) {
            return StackItemType.MAP;
        }
        if (typeName.equals(io.neow3j.devpack.List.class.getTypeName())) {
            return StackItemType.ARRAY;
        }
        if (typeName.equals(InteropInterface.class.getTypeName())) {
            return StackItemType.INTEROP_INTERFACE;
        }
        if (typeName.equals(Iterator.Struct.class.getTypeName())) {
            return StackItemType.STRUCT;
        }
        try {
            typeName = type.getDescriptor().replace("/", ".");
            Class<?> clazz = Class.forName(typeName);
            if (clazz.isArray()) {
                return StackItemType.ARRAY;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return StackItemType.ANY;
    }

    public CompilationUnit compile(String contractClass, List<ISourceContainer> sourceContainers) throws IOException {
        this.compUnit.addSourceContainers(sourceContainers);
        return this.compile(contractClass);
    }

    public CompilationUnit compile(String contractClass) throws IOException {
        return this.compile(AsmHelper.getAsmClass(contractClass, this.compUnit.getClassLoader()));
    }

    public CompilationUnit compile(InputStream classStream) throws IOException {
        return this.compile(AsmHelper.getAsmClass(classStream));
    }

    private CompilationUnit compile(ClassNode classNode) throws IOException {
        this.compUnit.setContractClass(classNode);
        this.checkForUsageOfInstanceConstructor(classNode);
        this.checkFieldVariables(classNode);
        this.collectSmartContractEvents(classNode);
        this.compUnit.getNeoModule().addMethod(this.createInitsslotMethod(classNode));
        this.compUnit.getNeoModule().addMethods(this.initializeContractMethods(classNode));
        for (NeoMethod neoMethod : new ArrayList<NeoMethod>(this.compUnit.getNeoModule().getSortedMethods())) {
            neoMethod.convert(this.compUnit);
        }
        this.finalizeCompilation();
        return this.compUnit;
    }

    private void checkFieldVariables(ClassNode asmClass) {
        if (asmClass.fields == null) {
            return;
        }
        if (asmClass.fields.size() > 255) {
            throw new CompilerException(String.format("The class %s has more than the max supported number of static field variables (%d).", ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name), 255));
        }
        if (asmClass.fields.stream().anyMatch(f -> (f.access & 8) == 0)) {
            throw new CompilerException(String.format("Class %s has non-static fields but only static fields are supported in smart contract classes.", ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name)));
        }
    }

    private void finalizeCompilation() {
        this.compUnit.getNeoModule().finalizeModule();
        NefFile nef = new NefFile(COMPILER_NAME, this.compUnit.getNeoModule().toByteArray(), this.compUnit.getNeoModule().getMethodTokens());
        ContractManifest manifest = ManifestBuilder.buildManifest(this.compUnit);
        this.compUnit.setNef(nef);
        this.compUnit.setManifest(manifest);
        this.compUnit.setDebugInfo(DebugInfo.buildDebugInfo(this.compUnit));
    }

    private void collectSmartContractEvents(ClassNode asmClass) {
        if (asmClass.fields == null || asmClass.fields.size() == 0) {
            return;
        }
        List<FieldNode> eventFields = asmClass.fields.stream().filter(field -> Compiler.isEvent(AsmHelper.getInternalNameForDescriptor(field.desc))).collect(Collectors.toList());
        if (eventFields.size() == 0) {
            return;
        }
        eventFields.forEach(field -> this.compUnit.getNeoModule().addEvent(new NeoEvent((FieldNode)field, asmClass)));
    }

    private void checkForUsageOfInstanceConstructor(ClassNode asmClass) {
        Optional<MethodNode> instanceCtor = asmClass.methods.stream().filter(m -> m.name.equals(INSTANCE_CTOR)).findFirst();
        if (instanceCtor.isPresent()) {
            MethodInsnNode insn = Compiler.skipToSuperCtorCall(instanceCtor.get(), asmClass);
            for (insn = insn.getNext(); insn != null; insn = insn.getNext()) {
                if (insn.getType() == 15 || insn.getType() == 8 || insn.getType() == 14 || insn.getOpcode() == JVMOpcode.RETURN.getOpcode()) continue;
                throw new CompilerException(String.format("Class %s has an explicit instance constructor, which is not supported.", ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name)));
            }
        }
    }

    private InitsslotNeoMethod createInitsslotMethod(ClassNode asmClass) {
        Optional<MethodNode> classCtorOpt = asmClass.methods.stream().filter(m -> m.name.equals(CLASS_CTOR)).findFirst();
        return classCtorOpt.map(methodNode -> new InitsslotNeoMethod((MethodNode)methodNode, asmClass)).orElse(null);
    }

    private List<NeoMethod> initializeContractMethods(ClassNode asmClass) {
        ArrayList<NeoMethod> methods = new ArrayList<NeoMethod>();
        for (MethodNode asmMethod : asmClass.methods) {
            if (asmMethod.name.equals(INSTANCE_CTOR) || asmMethod.name.equals(CLASS_CTOR)) continue;
            if ((asmMethod.access & 8) == 0) {
                throw new CompilerException(asmClass, String.format("Method '%s' of class %s is non-static but only static methods are allowed in smart contracts.", asmMethod.name, ClassUtils.getFullyQualifiedNameForInternalName((String)asmClass.name)));
            }
            if (this.compUnit.getNeoModule().hasMethod(NeoMethod.getMethodId(asmMethod, asmClass))) continue;
            NeoMethod neoMethod = new NeoMethod(asmMethod, asmClass);
            neoMethod.initialize(this.compUnit);
            methods.add(neoMethod);
        }
        return methods;
    }

    public static AbstractInsnNode handleInsn(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode;
        if (insn.getType() == 15) {
            neoMethod.setCurrentLine(((LineNumberNode)insn).line);
        }
        if (insn.getType() == 8) {
            neoMethod.setCurrentLabel(((LabelNode)insn).getLabel());
        }
        if ((opcode = JVMOpcode.get(insn.getOpcode())) == null) {
            return insn;
        }
        Converter converter = ConverterMap.get(opcode);
        if (converter == null) {
            throw new CompilerException(neoMethod, String.format("Unsupported instruction %s in method '%s' of class %s", opcode.toString(), neoMethod.getSourceMethodName(), ClassUtils.getFullyQualifiedNameForInternalName((String)neoMethod.getOwnerClass().name)));
        }
        return converter.convert(insn, neoMethod, compUnit);
    }

    public static void addSyscall(MethodNode calledAsmMethod, NeoMethod callingNeoMethod) {
        Compiler.addReverseArguments(calledAsmMethod, callingNeoMethod);
        Compiler.addSyscallInternal(calledAsmMethod, callingNeoMethod);
    }

    private static void addSyscallInternal(MethodNode calledAsmMethod, NeoMethod callingNeoMethod) {
        AnnotationNode syscallAnnotation = calledAsmMethod.invisibleAnnotations.stream().filter(a -> a.desc.equals(Type.getDescriptor(Syscall.Syscalls.class)) || a.desc.equals(Type.getDescriptor(Syscall.class))).findFirst().get();
        if (syscallAnnotation.desc.equals(Type.getDescriptor(Syscall.Syscalls.class))) {
            for (Object a2 : (List)syscallAnnotation.values.get(1)) {
                Compiler.addSingleSyscall((AnnotationNode)a2, callingNeoMethod);
            }
        } else {
            Compiler.addSingleSyscall(syscallAnnotation, callingNeoMethod);
        }
    }

    public static void addConstructorSyscall(MethodNode calledAsmMethod, NeoMethod callingNeoMethod) {
        Compiler.addSyscallInternal(calledAsmMethod, callingNeoMethod);
    }

    public static void addLoadConstant(AbstractInsnNode insn, NeoMethod neoMethod) {
        LdcInsnNode ldcInsn = (LdcInsnNode)insn;
        if (ldcInsn.cst instanceof String) {
            byte[] data = ((String)ldcInsn.cst).getBytes(StandardCharsets.UTF_8);
            neoMethod.addInstruction(Compiler.buildPushDataInsn(data));
        } else if (ldcInsn.cst instanceof Integer) {
            Compiler.addPushNumber(((Integer)ldcInsn.cst).intValue(), neoMethod);
        } else if (ldcInsn.cst instanceof Long) {
            Compiler.addPushNumber((Long)ldcInsn.cst, neoMethod);
        } else if (ldcInsn.cst instanceof Float || ldcInsn.cst instanceof Double) {
            throw new CompilerException(neoMethod, "Found use of float number but the compiler does not support floats.");
        }
    }

    public static NeoInstruction buildPushDataInsn(byte[] data) {
        return Compiler.buildPushDataInsnFromInsnBytes(new ScriptBuilder().pushData(data).toArray());
    }

    public static NeoInstruction buildPushDataInsn(String data) {
        return Compiler.buildPushDataInsnFromInsnBytes(new ScriptBuilder().pushData(data).toArray());
    }

    private static NeoInstruction buildPushDataInsnFromInsnBytes(byte[] insnBytes) {
        OpCode opcode = OpCode.get((byte)insnBytes[0]);
        int prefixSize = OpCode.getOperandSize((OpCode)opcode).prefixSize();
        byte[] operandPrefix = Arrays.copyOfRange(insnBytes, 1, 1 + prefixSize);
        byte[] operand = Arrays.copyOfRange(insnBytes, 1 + prefixSize, insnBytes.length);
        return new NeoInstruction(opcode, operandPrefix, operand);
    }

    public static MethodInsnNode skipToSuperCtorCall(MethodNode constructor, ClassNode owner) {
        ListIterator it = constructor.instructions.iterator();
        AbstractInsnNode insn = null;
        while (it.hasNext() && !Compiler.isCallToCtor(insn = (AbstractInsnNode)it.next(), owner.superName)) {
        }
        assert (insn != null && insn.getType() == 5) : "Expected call to constructor but couldn't find it.";
        return (MethodInsnNode)insn;
    }

    public static MethodInsnNode skipToCtorCall(AbstractInsnNode insn, ClassNode owner) {
        while (insn != null && !Compiler.isCallToCtor(insn = insn.getNext(), owner.name)) {
        }
        assert (insn != null && insn.getType() == 5) : "Expected call to constructor but couldn't find it.";
        return (MethodInsnNode)insn;
    }

    public static boolean isCallToCtor(AbstractInsnNode insn, String ownerInternalName) {
        return insn.getType() == 5 && ((MethodInsnNode)insn).owner.equals(ownerInternalName) && ((MethodInsnNode)insn).name.equals(INSTANCE_CTOR);
    }

    public static void addReverseArguments(MethodNode calledAsmMethod, NeoMethod callingNeoMethod) {
        int paramsCount = Type.getMethodType((String)calledAsmMethod.desc).getArgumentTypes().length;
        if ((calledAsmMethod.access & 8) == 0) {
            ++paramsCount;
        }
        Compiler.addReverseArguments(callingNeoMethod, paramsCount);
    }

    public static void addReverseArguments(NeoMethod callingNeoMethod, int paramsCount) {
        if (paramsCount == 2) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.SWAP));
        } else if (paramsCount == 3) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSE3));
        } else if (paramsCount == 4) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSE4));
        } else if (paramsCount > 4) {
            Compiler.addPushNumber(paramsCount, callingNeoMethod);
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.REVERSEN));
        }
    }

    private static void addSingleSyscall(AnnotationNode syscallAnnotation, NeoMethod neoMethod) {
        String syscallName = ((String[])syscallAnnotation.values.get(1))[1];
        InteropService syscall = InteropService.valueOf((String)syscallName);
        byte[] hash = Numeric.hexStringToByteArray((String)syscall.getHash());
        neoMethod.addInstruction(new NeoInstruction(OpCode.SYSCALL, hash));
    }

    public static void addInstructionsFromAnnotation(MethodNode asmMethod, NeoMethod neoMethod) {
        AnnotationNode insnAnnotation = asmMethod.invisibleAnnotations.stream().filter(a -> a.desc.equals(Type.getDescriptor(Instruction.Instructions.class)) || a.desc.equals(Type.getDescriptor(Instruction.class))).findFirst().get();
        if (insnAnnotation.desc.equals(Type.getDescriptor(Instruction.Instructions.class))) {
            for (Object a2 : (List)insnAnnotation.values.get(1)) {
                Compiler.addSingleInstruction((AnnotationNode)a2, neoMethod);
            }
        } else {
            Compiler.addSingleInstruction(insnAnnotation, neoMethod);
        }
    }

    private static void addSingleInstruction(AnnotationNode insnAnnotation, NeoMethod neoMethod) {
        if (insnAnnotation.values == null) {
            return;
        }
        String insnName = ((String[])insnAnnotation.values.get(1))[1];
        OpCode opcode = OpCode.valueOf((String)insnName);
        if (opcode.equals((Object)OpCode.NOP)) {
            return;
        }
        byte[] operandPrefix = new byte[]{};
        if (insnAnnotation.values.contains(INSTRUCTION_ANNOTATION_OPERAND_PREFIX)) {
            operandPrefix = Compiler.getOperandPrefix(insnAnnotation);
        }
        byte[] operand = new byte[]{};
        if (insnAnnotation.values.contains(INSTRUCTION_ANNOTATION_OPERAND)) {
            operand = Compiler.getOperand(insnAnnotation);
        }
        neoMethod.addInstruction(new NeoInstruction(opcode, operandPrefix, operand));
    }

    private static byte[] getOperandPrefix(AnnotationNode insnAnnotation) {
        return Compiler.getInstructionOperandBytes(insnAnnotation, INSTRUCTION_ANNOTATION_OPERAND_PREFIX);
    }

    private static byte[] getOperand(AnnotationNode insnAnnotation) {
        return Compiler.getInstructionOperandBytes(insnAnnotation, INSTRUCTION_ANNOTATION_OPERAND);
    }

    private static byte[] getInstructionOperandBytes(AnnotationNode insnAnnotation, String instructionAnnotationOperandPrefix) {
        byte[] operandPrefix = new byte[]{};
        int idx = insnAnnotation.values.indexOf(instructionAnnotationOperandPrefix);
        Object prefixObj = insnAnnotation.values.get(idx + 1);
        if (prefixObj instanceof byte[]) {
            operandPrefix = (byte[])prefixObj;
        } else if (prefixObj instanceof List) {
            List prefixObjAsList = (List)prefixObj;
            operandPrefix = new byte[prefixObjAsList.size()];
            int i = 0;
            for (Object element : prefixObjAsList) {
                operandPrefix[i++] = (Byte)element;
            }
        }
        return operandPrefix;
    }

    public static void addPushNumber(long number, NeoMethod neoMethod) {
        neoMethod.addInstruction(Compiler.buildPushNumberInstruction(BigInteger.valueOf(number)));
    }

    public static NeoInstruction buildPushNumberInstruction(BigInteger number) {
        byte[] insnBytes = new ScriptBuilder().pushInteger(number).toArray();
        byte[] operand = Arrays.copyOfRange(insnBytes, 1, insnBytes.length);
        return new NeoInstruction(OpCode.get((byte)insnBytes[0]), operand);
    }

    public static boolean isEvent(String classInternalName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(ClassUtils.getFullyQualifiedNameForInternalName((String)classInternalName));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return clazz.getInterfaces() != null && clazz.getInterfaces().length == 1 && clazz.getInterfaces()[0].equals(EventInterface.class);
    }
}

