/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.NeoVariable;
import io.neow3j.types.Hash160;
import io.neow3j.utils.ClassUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DebugInfo {
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="documents")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> documents;
    @JsonProperty(value="methods")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<Method> methods;
    @JsonProperty(value="events")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<Event> events;

    public DebugInfo() {
    }

    public DebugInfo(Hash160 hash, List<String> documents, List<Method> methods, List<Event> events) {
        this.hash = hash.toString();
        this.documents = documents;
        this.methods = methods;
        this.events = events;
    }

    public String getHash() {
        return this.hash;
    }

    public List<String> getDocuments() {
        return this.documents;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public static DebugInfo buildDebugInfo(CompilationUnit compUnit) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<String> documents = new ArrayList<String>();
        for (NeoMethod neoMethod : compUnit.getNeoModule().getSortedMethods()) {
            File sourceFile = compUnit.getSourceFile(neoMethod.getOwnerClass());
            if (sourceFile == null) continue;
            int docIdx = documents.indexOf(sourceFile.getAbsolutePath());
            if (docIdx == -1) {
                documents.add(sourceFile.getAbsolutePath());
                docIdx = documents.size() - 1;
            }
            String name = ClassUtils.getFullyQualifiedNameForInternalName((String)neoMethod.getOwnerClass().name) + "," + neoMethod.getName();
            String range = neoMethod.getStartAddress() + neoMethod.getInstructions().firstKey() + "-" + (neoMethod.getStartAddress() + neoMethod.getInstructions().lastKey());
            List<String> params = DebugInfo.collectVars(neoMethod.getParametersByNeoIndex().values());
            List<String> vars = DebugInfo.collectVars(neoMethod.getVariablesByNeoIndex().values());
            String returnType = Compiler.mapTypeToParameterType(Type.getMethodType((String)neoMethod.getAsmMethod().desc).getReturnType()).jsonValue();
            List<String> sequencePoints = DebugInfo.collectSequencePoints(neoMethod, docIdx);
            methods.add(new Method(neoMethod.getId(), name, range, params, returnType, vars, sequencePoints));
        }
        List<Event> events = compUnit.getNeoModule().getEvents().stream().map(NeoEvent::getAsDebugInfoEvent).collect(Collectors.toList());
        Hash160 hash160 = Hash160.fromScript((byte[])compUnit.getNefFile().getScript());
        return new DebugInfo(hash160, documents, methods, events);
    }

    private static List<String> collectSequencePoints(NeoMethod neoMethod, int documentIndex) {
        ArrayList<String> sequencePoints = new ArrayList<String>();
        for (NeoInstruction insn : neoMethod.getInstructions().values()) {
            if (insn.getLineNr() == null) continue;
            sequencePoints.add(neoMethod.getStartAddress() + insn.getAddress() + "[" + documentIndex + "]" + insn.getLineNr() + ":0-" + insn.getLineNr() + ":0");
        }
        return sequencePoints;
    }

    private static List<String> collectVars(Collection<NeoVariable> vars) {
        ArrayList<String> varStrings = new ArrayList<String>();
        for (NeoVariable var : vars) {
            String name = var.getName();
            if (name == null) continue;
            String type = Compiler.mapTypeToParameterType(Type.getType((String)var.getDescriptor())).jsonValue();
            varStrings.add(name + "," + type);
        }
        return varStrings;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Event {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="params")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        private List<String> params;

        public Event() {
        }

        public Event(String id, String name, List<String> params) {
            this.id = id;
            this.name = name;
            this.params = params;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getParams() {
            return this.params;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Method {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="range")
        private String range;
        @JsonProperty(value="params")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        private List<String> params;
        @JsonProperty(value="return")
        private String returnType;
        @JsonProperty(value="variables")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        private List<String> variables;
        @JsonProperty(value="sequence-points")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        private List<String> sequencePoints;

        public Method() {
        }

        public Method(String id, String name, String range, List<String> params, String returnType, List<String> variables, List<String> sequencePoints) {
            this.id = id;
            this.name = name;
            this.range = range;
            this.params = params;
            this.returnType = returnType;
            this.variables = variables;
            this.sequencePoints = sequencePoints;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getRange() {
            return this.range;
        }

        public List<String> getParams() {
            return this.params;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public List<String> getVariables() {
            return this.variables;
        }

        public List<String> getSequencePoints() {
            return this.sequencePoints;
        }
    }
}

