/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.script.OpCode;
import java.io.IOException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class InitsslotNeoMethod
extends NeoMethod {
    private static final String INITSSLOT_METHOD_NAME = "_initialize";

    public InitsslotNeoMethod(MethodNode asmMethod, ClassNode sourceClass) {
        super(asmMethod, sourceClass);
        this.setName(INITSSLOT_METHOD_NAME);
        this.setIsAbiMethod(true);
        byte[] operand = new byte[]{(byte)sourceClass.fields.size()};
        this.addInstruction(new NeoInstruction(OpCode.INITSSLOT, operand));
    }

    @Override
    public void convert(CompilationUnit compUnit) throws IOException {
        for (AbstractInsnNode insn = this.getAsmMethod().instructions.get(0); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() >= JVMOpcode.ISTORE.getOpcode() && insn.getOpcode() <= JVMOpcode.SASTORE.getOpcode()) {
                throw new CompilerException(this, "Local variables are not supported in the static constructor");
            }
            insn = Compiler.handleInsn(insn, this, compUnit);
        }
        this.insertTryCatchBlocks();
    }

    @Override
    public void initialize(CompilationUnit compUnit) {
        throw new UnsupportedOperationException("The INITSSLOT method cannotneed to be initialized with local variable and parameter slots.");
    }
}

