/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.NeoModule;
import io.neow3j.compiler.NeoVariable;
import io.neow3j.crypto.Base64;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.devpack.annotations.DisplayName;
import io.neow3j.devpack.annotations.ManifestExtra;
import io.neow3j.devpack.annotations.Permission;
import io.neow3j.devpack.annotations.Safe;
import io.neow3j.devpack.annotations.SupportedStandards;
import io.neow3j.devpack.annotations.Trust;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.ContractParameterType;
import io.neow3j.types.Hash160;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ManifestBuilder {
    public static ContractManifest buildManifest(CompilationUnit compUnit) {
        Optional<AnnotationNode> annotationNode = AsmHelper.getAnnotationNode(compUnit.getContractClass(), DisplayName.class);
        String name = ClassUtils.getClassNameForInternalName((String)compUnit.getContractClass().name);
        if (annotationNode.isPresent()) {
            name = (String)annotationNode.get().values.get(1);
        }
        Map<String, String> extras = ManifestBuilder.buildManifestExtra(compUnit.getContractClass());
        List<String> supportedStandards = ManifestBuilder.buildSupportedStandards(compUnit.getContractClass());
        ContractManifest.ContractABI abi = ManifestBuilder.buildABI(compUnit.getNeoModule());
        ArrayList groups = new ArrayList();
        List<ContractManifest.ContractPermission> permissions = ManifestBuilder.buildPermissions(compUnit.getContractClass());
        List<String> trusts = ManifestBuilder.buildTrusts(compUnit.getContractClass());
        return new ContractManifest(name, groups, null, supportedStandards, abi, permissions, trusts, extras);
    }

    private static ContractManifest.ContractABI buildABI(NeoModule neoModule) {
        List events = neoModule.getEvents().stream().map(NeoEvent::getAsContractManifestEvent).collect(Collectors.toList());
        ArrayList<ContractManifest.ContractABI.ContractMethod> methods = new ArrayList<ContractManifest.ContractABI.ContractMethod>();
        for (NeoMethod neoMethod : neoModule.getSortedMethods()) {
            if (!neoMethod.isAbiMethod()) continue;
            ArrayList<ContractParameter> contractParams = new ArrayList<ContractParameter>();
            for (NeoVariable var : neoMethod.getParametersByNeoIndex().values()) {
                contractParams.add(new ContractParameter(var.getName(), Compiler.mapTypeToParameterType(Type.getType((String)var.getDescriptor()))));
            }
            ContractParameterType paramType = Compiler.mapTypeToParameterType(Type.getMethodType((String)neoMethod.getAsmMethod().desc).getReturnType());
            boolean isSafe = AsmHelper.hasAnnotations(neoMethod.getAsmMethod(), Safe.class);
            methods.add(new ContractManifest.ContractABI.ContractMethod(neoMethod.getName(), contractParams, neoMethod.getStartAddress(), paramType, isSafe));
        }
        return new ContractManifest.ContractABI(methods, events);
    }

    private static Map<String, String> buildManifestExtra(ClassNode classNode) {
        List<AnnotationNode> annotations = ManifestBuilder.checkForSingleOrMultipleAnnotations(classNode, ManifestExtra.ManifestExtras.class, ManifestExtra.class);
        HashMap<String, String> extras = new HashMap<String, String>();
        for (AnnotationNode node : annotations) {
            int i = node.values.indexOf("key");
            String key = (String)node.values.get(i + 1);
            i = node.values.indexOf("value");
            String value = (String)node.values.get(i + 1);
            extras.put(key, value);
        }
        return extras;
    }

    private static List<String> buildSupportedStandards(ClassNode asmClass) {
        return AsmHelper.getAnnotationNode(asmClass, SupportedStandards.class).flatMap(ManifestBuilder::transformAnnotationNodeStringValue).orElse(new ArrayList());
    }

    public static List<ContractManifest.ContractPermission> buildPermissions(ClassNode asmClass) {
        List<ContractManifest.ContractPermission> permissions = ManifestBuilder.checkForSingleOrMultipleAnnotations(asmClass, Permission.Permissions.class, Permission.class).stream().map(ManifestBuilder::getContractPermission).collect(Collectors.toList());
        if (permissions.isEmpty()) {
            return new ArrayList<ContractManifest.ContractPermission>();
        }
        return permissions;
    }

    private static List<String> buildTrusts(ClassNode asmClass) {
        return ManifestBuilder.checkForSingleOrMultipleAnnotations(asmClass, Trust.Trusts.class, Trust.class).stream().map(ManifestBuilder::getContractTrust).collect(Collectors.toList());
    }

    private static Optional<List<String>> transformAnnotationNodeStringValue(AnnotationNode annotationNode) {
        return Optional.ofNullable(annotationNode).map(ann -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Object value : (List)ann.values.get(1)) {
                values.add((String)value);
            }
            return values;
        });
    }

    private static ContractManifest.ContractPermission getContractPermission(AnnotationNode ann) {
        int i = ann.values.indexOf("contract");
        String hashOrPubKey = (String)ann.values.get(i + 1);
        ManifestBuilder.throwIfNotValidContractHashOrPubKeyOrWildcard(hashOrPubKey);
        hashOrPubKey = ManifestBuilder.addOrClearHexPrefix(hashOrPubKey);
        i = ann.values.indexOf("methods");
        ArrayList<String> methods = new ArrayList<String>();
        if (i < 0) {
            methods.add("*");
        } else {
            List methodsValues = (List)ann.values.get(i + 1);
            methods.addAll(methodsValues);
        }
        return new ContractManifest.ContractPermission(hashOrPubKey, methods);
    }

    private static String addOrClearHexPrefix(String hashOrPubKey) {
        if (hashOrPubKey.length() == 40) {
            hashOrPubKey = Numeric.prependHexPrefix((String)hashOrPubKey);
        } else if (hashOrPubKey.length() == 68) {
            hashOrPubKey = Numeric.cleanHexPrefix((String)hashOrPubKey);
        }
        return hashOrPubKey;
    }

    private static ContractManifest.ContractGroup getContractGroup(AnnotationNode ann) {
        int i = ann.values.indexOf("pubKey");
        String pubKey = (String)ann.values.get(i + 1);
        i = ann.values.indexOf("signature");
        String signature = (String)ann.values.get(i + 1);
        ManifestBuilder.throwIfNotValidPubKey(pubKey);
        ManifestBuilder.throwIfNotValidSignature(signature);
        return new ContractManifest.ContractGroup(pubKey, signature);
    }

    private static void throwIfNotValidSignature(String signature) {
        try {
            Base64.decode((String)signature);
        }
        catch (Exception e) {
            throw new CompilerException(String.format("Invalid signature: %s. Please, add a valid signature in base64 format.", signature));
        }
    }

    private static void throwIfNotValidPubKey(String pubKey) {
        try {
            new ECKeyPair.ECPublicKey(pubKey);
        }
        catch (Exception e) {
            throw new CompilerException(String.format("Invalid public key: %s", pubKey));
        }
    }

    private static void throwIfNotValidContractHash(String contractHash) {
        try {
            new Hash160(contractHash);
        }
        catch (Exception e) {
            throw new CompilerException(String.format("Invalid contract hash: %s", contractHash));
        }
    }

    private static void throwIfNotValidContractHashOrPubKeyOrWildcard(String contract) {
        if (contract != null && contract.equals("*")) {
            return;
        }
        Exception notValidContractHash = null;
        try {
            ManifestBuilder.throwIfNotValidContractHash(contract);
        }
        catch (Exception e) {
            notValidContractHash = e;
        }
        Exception notValidPubKey = null;
        try {
            ManifestBuilder.throwIfNotValidPubKey(contract);
        }
        catch (Exception e) {
            notValidPubKey = e;
        }
        if (notValidContractHash != null && notValidPubKey != null) {
            throw new CompilerException(String.format("Invalid contract hash or public key: %s", contract));
        }
    }

    private static String getContractTrust(AnnotationNode ann) {
        int i = ann.values.indexOf("value");
        String trust = (String)ann.values.get(i + 1);
        ManifestBuilder.throwIfNotValidContractHashOrPubKeyOrWildcard(trust);
        return ManifestBuilder.addOrClearHexPrefix(trust);
    }

    private static List<AnnotationNode> checkForSingleOrMultipleAnnotations(ClassNode asmClass, Class<?> multipleAnnotationType, Class<?> singleAnnotationType) {
        Optional<AnnotationNode> annotation = AsmHelper.getAnnotationNode(asmClass, multipleAnnotationType);
        return annotation.map(a -> (List)a.values.get(1)).orElseGet(() -> {
            Optional<AnnotationNode> ann = AsmHelper.getAnnotationNode(asmClass, singleAnnotationType);
            ArrayList annotations = new ArrayList();
            ann.map(annotations::add);
            return annotations;
        });
    }
}

