/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.DebugInfo;
import io.neow3j.devpack.annotations.DisplayName;
import io.neow3j.protocol.core.response.ContractManifest;
import io.neow3j.types.ContractParameter;
import io.neow3j.utils.ClassUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class NeoEvent {
    private static final String PARAM_NAME_PREFIX = "arg";
    private final String displayName;
    private final List<Param> params;
    private final String namespace;
    private final FieldNode asmVariable;

    public NeoEvent(FieldNode asmVariable, ClassNode owner) {
        Optional<AnnotationNode> annOpt = AsmHelper.getAnnotationNode(asmVariable, DisplayName.class);
        this.displayName = annOpt.isPresent() ? (String)annOpt.get().values.get(1) : asmVariable.name;
        AtomicInteger argNr = new AtomicInteger(1);
        this.params = AsmHelper.extractTypeParametersFromSignature(asmVariable).stream().map(t -> new Param(PARAM_NAME_PREFIX + argNr.getAndIncrement(), Type.getType((String)t))).collect(Collectors.toList());
        this.namespace = ClassUtils.getFullyQualifiedNameForInternalName((String)owner.name);
        this.asmVariable = asmVariable;
    }

    public FieldNode getAsmVariable() {
        return this.asmVariable;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.namespace + "#" + this.asmVariable.name;
    }

    public int getNumberOfParams() {
        return this.params.size();
    }

    public ContractManifest.ContractABI.ContractEvent getAsContractManifestEvent() {
        List contractParameters = this.params.stream().map(rec$ -> ((Param)rec$).getAsContractParameter()).collect(Collectors.toList());
        return new ContractManifest.ContractABI.ContractEvent(this.displayName, contractParameters);
    }

    public DebugInfo.Event getAsDebugInfoEvent() {
        List<String> contractParameters = this.params.stream().map(rec$ -> ((Param)rec$).getAsStringForDebugInfo()).collect(Collectors.toList());
        String name = this.namespace.substring(this.namespace.lastIndexOf(".") + 1) + "," + this.displayName;
        return new DebugInfo.Event(this.getId(), name, contractParameters);
    }

    private static class Param {
        private final String name;
        private final Type type;

        private Param(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        private String getAsStringForDebugInfo() {
            return this.name + "," + Compiler.mapTypeToParameterType(this.type).jsonValue();
        }

        private ContractParameter getAsContractParameter() {
            return new ContractParameter(this.name, Compiler.mapTypeToParameterType(this.type));
        }
    }
}

