/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoJumpInstruction;
import io.neow3j.compiler.NeoTryInstruction;
import io.neow3j.compiler.NeoVariable;
import io.neow3j.devpack.annotations.MethodSignature;
import io.neow3j.devpack.annotations.Safe;
import io.neow3j.script.OpCode;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.ClassUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class NeoMethod {
    private final MethodNode asmMethod;
    private final ClassNode sourceClass;
    private String name;
    private SortedMap<Integer, NeoInstruction> instructions = new TreeMap<Integer, NeoInstruction>();
    private final List<NeoJumpInstruction> jumpInstructions = new ArrayList<NeoJumpInstruction>();
    private final Map<Label, NeoInstruction> jumpTargets = new HashMap<Label, NeoInstruction>();
    private final List<NeoTryInstruction> tryInstructions = new ArrayList<NeoTryInstruction>();
    private final SortedMap<Integer, NeoVariable> variablesByNeoIndex = new TreeMap<Integer, NeoVariable>();
    private final SortedMap<Integer, NeoVariable> variablesByJVMIndex = new TreeMap<Integer, NeoVariable>();
    private final SortedMap<Integer, NeoVariable> parametersByNeoIndex = new TreeMap<Integer, NeoVariable>();
    private final SortedMap<Integer, NeoVariable> parametersByJVMIndex = new TreeMap<Integer, NeoVariable>();
    private boolean isAbiMethod = false;
    private int lastAddress = 0;
    private Integer startAddress = null;
    private Label currentLabel;
    private int currentLine;
    private boolean isFreshNewLine = false;
    private final List<TryCatchFinallyBlock> tryCatchFinallyBlocks = new ArrayList<TryCatchFinallyBlock>();

    public NeoMethod(MethodNode asmMethod, ClassNode sourceClass) {
        this.asmMethod = asmMethod;
        this.name = asmMethod.name;
        this.sourceClass = sourceClass;
        this.handleExpectedMethodSignatureAnnotation();
        this.collectTryCatchBlocks(asmMethod.tryCatchBlocks);
    }

    public MethodSignature getMethodSignatureAnnotation() {
        if (this.asmMethod.invisibleAnnotations == null) {
            return null;
        }
        List annotations = this.asmMethod.invisibleAnnotations.stream().map(a -> {
            try {
                return Class.forName(Type.getType((String)a.desc).getClassName()).getAnnotation(MethodSignature.class);
            }
            catch (ClassNotFoundException e) {
                throw new CompilerException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new CompilerException(this.sourceClass, String.format("The method %s cannot have multiple annotations that require a specific method signature.", this.getSourceMethodName()));
        }
        return (MethodSignature)annotations.get(0);
    }

    private void handleExpectedMethodSignatureAnnotation() {
        Type expectedReturnType;
        MethodSignature expectedSig = this.getMethodSignatureAnnotation();
        if (expectedSig == null) {
            return;
        }
        Object[] actualParameterTypes = Type.getType((String)this.asmMethod.desc).getArgumentTypes();
        Object[] expectedParameterTypes = (Type[])Arrays.stream(expectedSig.parameterTypes()).map(Type::getType).toArray(Type[]::new);
        Type actualReturnType = Type.getType((String)this.asmMethod.desc).getReturnType();
        if (!actualReturnType.equals((Object)(expectedReturnType = Type.getType((Class)expectedSig.returnType()))) || expectedParameterTypes.length != 0 && !Arrays.equals(actualParameterTypes, expectedParameterTypes)) {
            String paramTypesString = Arrays.stream(expectedSig.parameterTypes()).map(c -> "'" + c.getName() + "'").collect(Collectors.joining(", "));
            String message = String.format("The annotated method '%s' is required to have the parameters (%s) and return type '%s'.", this.getSourceMethodName(), paramTypesString, expectedSig.returnType().getName());
            if (expectedParameterTypes.length == 0) {
                message = String.format("The annotated method '%s' is required to have return type '%s'.", this.getSourceMethodName(), expectedSig.returnType().getName());
            }
            throw new CompilerException(this.sourceClass, message);
        }
        this.name = expectedSig.name();
    }

    private void collectTryCatchBlocks(List<TryCatchBlockNode> blockNodes) {
        if (blockNodes == null || blockNodes.isEmpty()) {
            return;
        }
        this.checkForUnsupportedExceptionTypes(blockNodes);
        Set<TryCatchBlockNode> parsedNodes = this.collectBlocksWithCatchAndOptionallyFinally(blockNodes);
        this.collectBlocksWithNoCatchButFinally(blockNodes, parsedNodes);
    }

    private void checkForUnsupportedExceptionTypes(List<TryCatchBlockNode> blockNodes) {
        Optional<String> unsupportedException = blockNodes.stream().map(node -> node.type).filter(type -> type != null && !type.equals(Type.getType(Exception.class).getInternalName())).findFirst();
        if (unsupportedException.isPresent()) {
            throw new CompilerException(this.sourceClass, String.format("Contract tries to catch an exception of type %s but only %s is supported.", ClassUtils.getFullyQualifiedNameForInternalName((String)unsupportedException.get()), Exception.class.getCanonicalName()));
        }
    }

    private Set<TryCatchBlockNode> collectBlocksWithCatchAndOptionallyFinally(List<TryCatchBlockNode> blockNodes) {
        HashSet<TryCatchBlockNode> parsedNodes = new HashSet<TryCatchBlockNode>();
        for (TryCatchBlockNode block : blockNodes) {
            if (block.type == null) continue;
            parsedNodes.add(block);
            Optional<TryCatchBlockNode> catchBlockNode = blockNodes.stream().filter(b -> b.type == null && b.start == block.handler).findFirst();
            LabelNode endCatchLabelNode = null;
            if (catchBlockNode.isPresent()) {
                parsedNodes.add(catchBlockNode.get());
                endCatchLabelNode = catchBlockNode.get().end;
            }
            Optional<TryCatchBlockNode> finallyBlockNode = blockNodes.stream().filter(b -> b.type == null && b.start == block.start && b.end == block.end).findFirst();
            LabelNode finallyLabelNode = null;
            if (finallyBlockNode.isPresent()) {
                parsedNodes.add(finallyBlockNode.get());
                finallyLabelNode = finallyBlockNode.get().handler;
            }
            this.tryCatchFinallyBlocks.add(new TryCatchFinallyBlock(block.start, block.end, block.handler, endCatchLabelNode, finallyLabelNode));
        }
        return parsedNodes;
    }

    private void collectBlocksWithNoCatchButFinally(List<TryCatchBlockNode> blockNodes, Set<TryCatchBlockNode> parsedNodes) {
        blockNodes.stream().filter(blockNode -> !parsedNodes.contains(blockNode) && blockNode.type == null && blockNode.start != blockNode.handler).forEach(block -> this.tryCatchFinallyBlocks.add(new TryCatchFinallyBlock(block.start, block.end, null, null, block.handler)));
    }

    public MethodNode getAsmMethod() {
        return this.asmMethod;
    }

    public ClassNode getOwnerClass() {
        return this.sourceClass;
    }

    public String getOwnerClassName() {
        return ClassUtils.getFullyQualifiedNameForInternalName((String)this.sourceClass.name);
    }

    public String getId() {
        return NeoMethod.getMethodId(this.asmMethod, this.sourceClass);
    }

    public String getName() {
        return this.name;
    }

    public String getSourceMethodName() {
        return this.asmMethod.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getMethodId(MethodNode asmMethod, ClassNode owner) {
        return owner.name + "." + asmMethod.name + asmMethod.desc;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(int currentLine) {
        this.currentLine = currentLine;
        this.isFreshNewLine = true;
    }

    public void setCurrentLabel(Label currentLabel) {
        this.currentLabel = currentLabel;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(int startAddress) {
        this.startAddress = startAddress;
    }

    public boolean isAbiMethod() {
        return this.isAbiMethod;
    }

    public void setIsAbiMethod(boolean abiMethod) {
        this.isAbiMethod = abiMethod;
    }

    public SortedMap<Integer, NeoInstruction> getInstructions() {
        return this.instructions;
    }

    public SortedMap<Integer, NeoVariable> getVariablesByNeoIndex() {
        return this.variablesByNeoIndex;
    }

    public SortedMap<Integer, NeoVariable> getParametersByNeoIndex() {
        return this.parametersByNeoIndex;
    }

    public int getLastAddress() {
        return this.lastAddress;
    }

    public void addParameter(NeoVariable var) {
        this.parametersByNeoIndex.put(var.getNeoIndex(), var);
        this.parametersByJVMIndex.put(var.getJvmIndex(), var);
    }

    public void addVariable(NeoVariable var) {
        this.variablesByNeoIndex.put(var.getNeoIndex(), var);
        this.variablesByJVMIndex.put(var.getJvmIndex(), var);
    }

    public NeoVariable getVariableByJVMIndex(int index) {
        return (NeoVariable)this.variablesByJVMIndex.get(index);
    }

    public NeoVariable getParameterByJVMIndex(int index) {
        return (NeoVariable)this.parametersByJVMIndex.get(index);
    }

    public void convert(CompilationUnit compUnit) throws IOException {
        for (AbstractInsnNode insn = this.asmMethod.instructions.get(0); insn != null; insn = insn.getNext()) {
            insn = Compiler.handleInsn(insn, this, compUnit);
        }
        this.insertTryCatchBlocks();
    }

    protected void insertTryCatchBlocks() {
        for (TryCatchFinallyBlock block : this.tryCatchFinallyBlocks) {
            this.insertTryInstruction(block);
        }
    }

    private void insertTryInstruction(TryCatchFinallyBlock block) {
        NeoInstruction insn = this.jumpTargets.get(block.tryLabelNode.getLabel());
        if (insn == null) {
            throw new CompilerException(this.sourceClass, "Could not find the beginning instruction of a try block.");
        }
        Label catchLabel = null;
        if (block.catchLabelNode != null) {
            catchLabel = block.catchLabelNode.getLabel();
        }
        Label finallyLabel = null;
        if (block.finallyLabelNode != null) {
            finallyLabel = block.finallyLabelNode.getLabel();
        }
        NeoTryInstruction tryInsn = new NeoTryInstruction(catchLabel, finallyLabel);
        this.insertInstruction(insn.getAddress(), tryInsn);
        this.tryInstructions.add(tryInsn);
        this.jumpTargets.put(block.tryLabelNode.getLabel(), tryInsn);
    }

    private void insertInstruction(int atAddr, NeoInstruction newInsn) {
        SortedMap<Integer, NeoInstruction> head = this.instructions.headMap(atAddr);
        SortedMap<Integer, NeoInstruction> tail = this.instructions.tailMap(atAddr);
        TreeMap<Integer, NeoInstruction> newMap = new TreeMap<Integer, NeoInstruction>(head);
        newInsn.setAddress(atAddr);
        newMap.put(newInsn.getAddress(), newInsn);
        int shift = newInsn.byteSize();
        tail.forEach((i, insn) -> {
            insn.setAddress(i + shift);
            newMap.put(i + shift, (NeoInstruction)insn);
        });
        this.instructions = newMap;
        this.increaseLastAddress(newInsn);
    }

    public void addInstruction(NeoInstruction neoInsn) {
        if (this.isFreshNewLine) {
            neoInsn.setLineNr(this.currentLine);
            this.isFreshNewLine = false;
        }
        if (this.currentLabel != null) {
            this.jumpTargets.put(this.currentLabel, neoInsn);
            this.currentLabel = null;
        }
        this.addInstructionInternal(neoInsn);
    }

    private void addInstructionInternal(NeoInstruction neoInsn) {
        neoInsn.setAddress(this.lastAddress);
        this.instructions.put(this.lastAddress, neoInsn);
        if (neoInsn instanceof NeoJumpInstruction) {
            this.jumpInstructions.add((NeoJumpInstruction)neoInsn);
        }
        this.increaseLastAddress(neoInsn);
    }

    private void increaseLastAddress(NeoInstruction neoInsn) {
        this.lastAddress += neoInsn.byteSize();
    }

    public void removeLastInstruction() {
        NeoInstruction lastInsn = (NeoInstruction)this.instructions.get(this.instructions.lastKey());
        if (this.jumpTargets.containsValue(lastInsn)) {
            throw new CompilerException(this, "Attempting to remove an instruction that is a jump target for another instruction.");
        }
        this.removeLastInstructionInternal();
    }

    private void removeLastInstructionInternal() {
        NeoInstruction insn = (NeoInstruction)this.instructions.remove(this.instructions.lastKey());
        this.jumpInstructions.remove(insn);
        this.lastAddress -= insn.byteSize();
    }

    public void replaceLastInstruction(NeoInstruction newInsn) {
        NeoInstruction lastInsn = (NeoInstruction)this.instructions.get(this.instructions.lastKey());
        if (this.jumpTargets.containsValue(lastInsn)) {
            Optional<Map.Entry> jumpTarget = this.jumpTargets.entrySet().stream().filter(e -> e.getValue() == lastInsn).findFirst();
            Label label = (Label)jumpTarget.get().getKey();
            this.jumpTargets.remove(label);
            this.jumpTargets.put(label, newInsn);
        }
        if (lastInsn.getLineNr() != null) {
            newInsn.setLineNr(lastInsn.getLineNr());
        }
        this.removeLastInstructionInternal();
        this.addInstructionInternal(newInsn);
    }

    public NeoInstruction getLastInstruction() {
        return (NeoInstruction)this.instructions.get(this.instructions.lastKey());
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.byteSize()];
        int i = 0;
        for (NeoInstruction insn : this.instructions.values()) {
            byte[] insnBytes = insn.toByteArray();
            System.arraycopy(insnBytes, 0, bytes, i, insnBytes.length);
            i += insnBytes.length;
        }
        return bytes;
    }

    protected int byteSize() {
        return this.instructions.values().stream().map(NeoInstruction::byteSize).reduce(Integer::sum).get();
    }

    protected void finalizeMethod() {
        this.setJumpInstructionOffsets();
        this.setTryInstructionOffsets();
    }

    private void setJumpInstructionOffsets() {
        for (NeoJumpInstruction jumpInsn : this.jumpInstructions) {
            if (jumpInsn.getLabel() == null) continue;
            if (!this.jumpTargets.containsKey(jumpInsn.getLabel())) {
                throw new CompilerException(String.format("Missing jump target for opcode %s, at source code line number %d.", jumpInsn.getOpcode().name(), jumpInsn.getLineNr()));
            }
            NeoInstruction destinationInsn = this.jumpTargets.get(jumpInsn.getLabel());
            int offset = destinationInsn.getAddress() - jumpInsn.getAddress();
            jumpInsn.setOperand(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(offset).array());
        }
    }

    private void setTryInstructionOffsets() {
        for (NeoTryInstruction tryInsn : this.tryInstructions) {
            byte[] catchOffset = new byte[4];
            if (tryInsn.getCatchOffsetLabel() != null) {
                if (!this.jumpTargets.containsKey(tryInsn.getCatchOffsetLabel())) {
                    throw new CompilerException("Missing target instruction for catch block of a try block");
                }
                NeoInstruction destInsn = this.jumpTargets.get(tryInsn.getCatchOffsetLabel());
                int offset = destInsn.getAddress() - tryInsn.getAddress();
                catchOffset = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(offset).array();
            }
            byte[] finallyOffset = new byte[4];
            if (tryInsn.getFinallyOffsetLabel() != null) {
                if (!this.jumpTargets.containsKey(tryInsn.getFinallyOffsetLabel())) {
                    throw new CompilerException("Missing target instruction for finally block of a try block");
                }
                NeoInstruction destInsn = this.jumpTargets.get(tryInsn.getFinallyOffsetLabel());
                int offset = destInsn.getAddress() - tryInsn.getAddress();
                finallyOffset = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(offset).array();
            }
            tryInsn.setOperand(ArrayUtils.concatenate((byte[])catchOffset, (byte[])finallyOffset));
        }
    }

    public void initialize(CompilationUnit compUnit) {
        if ((this.asmMethod.access & 1) > 0 && (this.asmMethod.access & 8) > 0 && compUnit.getContractClass().equals(this.sourceClass)) {
            this.setIsAbiMethod(true);
        } else if (AsmHelper.hasAnnotations(this.asmMethod, Safe.class)) {
            throw new CompilerException(this.sourceClass, String.format("Method '%s' is not a public contract method, therefore, marking it as \"safe\" is obsolete and has no effect.", this.getSourceMethodName()));
        }
        this.initializeLocalVariablesAndParameters();
    }

    private void initializeLocalVariablesAndParameters() {
        this.checkForUnsupportedLocalVariableTypes();
        if (this.asmMethod.maxLocals == 0) {
            return;
        }
        int nextVarIdx = this.collectMethodParameters();
        this.collectLocalVariables(nextVarIdx);
        if (this.variablesByNeoIndex.size() + this.parametersByNeoIndex.size() > 0) {
            this.addInstruction(new NeoInstruction(OpCode.INITSLOT, new byte[]{(byte)this.variablesByNeoIndex.size(), (byte)this.parametersByNeoIndex.size()}));
        }
    }

    private void checkForUnsupportedLocalVariableTypes() {
        for (LocalVariableNode varNode : this.asmMethod.localVariables) {
            if (Type.getType((String)varNode.desc) != Type.DOUBLE_TYPE && Type.getType((String)varNode.desc) != Type.FLOAT_TYPE) continue;
            throw new CompilerException(this, String.format("Method '%s' has unsupported parameter or variable types.", this.asmMethod.name));
        }
    }

    private void collectLocalVariables(int nextVarIdx) {
        int localVarCount;
        int paramCount = Type.getArgumentTypes((String)this.asmMethod.desc).length;
        List locVars = this.asmMethod.localVariables;
        if (locVars.size() > 0 && this.containsThisParam(locVars)) {
            ++paramCount;
        }
        if ((localVarCount = this.asmMethod.maxLocals - paramCount) > 255) {
            throw new CompilerException(String.format("The method '%s' has %d local variables but only a max of %d is supported.", this.getSourceMethodName(), localVarCount, 255));
        }
        int jvmIdx = nextVarIdx;
        for (int neoIdx = 0; neoIdx < localVarCount; ++neoIdx) {
            NeoVariable neoVar = null;
            for (LocalVariableNode varNode : locVars) {
                if (varNode.index != jvmIdx) continue;
                neoVar = new NeoVariable(neoIdx, jvmIdx, varNode);
                if (Type.getType((String)varNode.desc) != Type.LONG_TYPE) break;
                ++jvmIdx;
                break;
            }
            if (neoVar == null) {
                neoVar = new NeoVariable(neoIdx, jvmIdx, null);
            }
            this.addVariable(neoVar);
            ++jvmIdx;
        }
    }

    private int collectMethodParameters() {
        int paramCount = 0;
        List locVars = this.asmMethod.localVariables;
        if (locVars.size() > 0 && this.containsThisParam(locVars)) {
            ++paramCount;
        }
        if ((paramCount += Type.getArgumentTypes((String)this.asmMethod.desc).length) > 255) {
            throw new CompilerException(String.format("The method '%s' has %d parameters but only a max of %d is supported.", this.getSourceMethodName(), paramCount, 255));
        }
        int jvmIdx = 0;
        for (int neoIdx = 0; neoIdx < paramCount; ++neoIdx) {
            NeoVariable neoParam = null;
            for (LocalVariableNode varNode : locVars) {
                if (varNode.index != jvmIdx) continue;
                neoParam = new NeoVariable(neoIdx, jvmIdx, varNode);
                if (Type.getType((String)varNode.desc) != Type.LONG_TYPE) break;
                ++jvmIdx;
                break;
            }
            if (neoParam == null) {
                neoParam = new NeoVariable(neoIdx, jvmIdx, null);
            }
            this.addParameter(neoParam);
            ++jvmIdx;
        }
        return jvmIdx;
    }

    private boolean containsThisParam(List<LocalVariableNode> locVars) {
        return locVars.stream().anyMatch(v -> v.name.equals("this"));
    }

    private static class TryCatchFinallyBlock {
        private final LabelNode tryLabelNode;
        private final LabelNode endTryLabelNode;
        private final LabelNode catchLabelNode;
        private final LabelNode endCatchLabelNode;
        private final LabelNode finallyLabelNode;

        private TryCatchFinallyBlock(LabelNode tryLabelNode, LabelNode endTryLabelNode, LabelNode catchLabelNode, LabelNode endCatchLabelNode, LabelNode finallyLabelNode) {
            this.tryLabelNode = tryLabelNode;
            this.endTryLabelNode = endTryLabelNode;
            this.catchLabelNode = catchLabelNode;
            this.endCatchLabelNode = endCatchLabelNode;
            this.finallyLabelNode = finallyLabelNode;
        }
    }
}

