/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler;

import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.contract.NefFile;
import io.neow3j.script.OpCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NeoModule {
    private final Map<String, NeoMethod> methods = new HashMap<String, NeoMethod>();
    private final List<NeoMethod> sortedMethods = new ArrayList<NeoMethod>();
    private final Map<String, NeoEvent> events = new HashMap<String, NeoEvent>();
    private List<NefFile.MethodToken> methodTokens = new ArrayList<NefFile.MethodToken>();

    public List<NeoEvent> getEvents() {
        return new ArrayList<NeoEvent>(this.events.values());
    }

    public List<NeoMethod> getSortedMethods() {
        return this.sortedMethods;
    }

    public int getIndexOfMethodToken(NefFile.MethodToken token) {
        int idx = 0;
        for (NefFile.MethodToken t : this.methodTokens) {
            if (token.equals((Object)t)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int addMethodToken(NefFile.MethodToken token) {
        int idx = this.getIndexOfMethodToken(token);
        if (idx != -1) {
            return idx;
        }
        this.methodTokens.add(token);
        return this.methodTokens.size() - 1;
    }

    public List<NefFile.MethodToken> getMethodTokens() {
        return this.methodTokens;
    }

    public void addMethod(NeoMethod method) {
        if (method != null) {
            this.methods.put(method.getId(), method);
            this.sortedMethods.add(method);
        }
    }

    public void addMethods(List<NeoMethod> newMethods) {
        if (newMethods != null) {
            newMethods.forEach(this::addMethod);
        }
    }

    public void addEvent(NeoEvent event) {
        if (this.events.containsKey(event.getDisplayName())) {
            throw new CompilerException(String.format("Two events with the name '%s' are defined. Make sure that every event has a different name.", event.getDisplayName()));
        }
        this.events.put(event.getDisplayName(), event);
    }

    void finalizeModule() {
        this.checkForDuplicatesOfMethodSignatureAnnotations();
        int startAddress = 0;
        for (NeoMethod method : this.sortedMethods) {
            method.finalizeMethod();
            method.setStartAddress(startAddress);
            startAddress += method.getLastAddress();
        }
        for (NeoMethod method : this.sortedMethods) {
            for (Map.Entry<Integer, NeoInstruction> entry : method.getInstructions().entrySet()) {
                NeoInstruction insn = entry.getValue();
                if (!insn.getOpcode().equals((Object)OpCode.CALL_L)) continue;
                if (!(insn.getExtra() instanceof NeoMethod)) {
                    throw new CompilerException(String.format("Instruction with %s opcode is missing the reference to the called method. The jump address cannot be resolved.", OpCode.CALL_L.name()));
                }
                NeoMethod calledMethod = (NeoMethod)insn.getExtra();
                int offset = calledMethod.getStartAddress() - (method.getStartAddress() + entry.getKey());
                insn.setOperand(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(offset).array());
            }
        }
    }

    private void checkForDuplicatesOfMethodSignatureAnnotations() {
        HashSet methodSigs = new HashSet();
        this.sortedMethods.stream().map(NeoMethod::getMethodSignatureAnnotation).filter(Objects::nonNull).forEach(sig -> {
            if (methodSigs.contains(sig)) {
                throw new CompilerException(String.format("There are multiple methods that are annotated as candidates for the '%s' method but only one is allowed.", sig.name()));
            }
            methodSigs.add(sig);
        });
    }

    int byteSize() {
        return this.sortedMethods.stream().map(NeoMethod::byteSize).reduce(Integer::sum).get();
    }

    byte[] toByteArray() {
        ByteBuffer b = ByteBuffer.allocate(this.byteSize());
        this.sortedMethods.forEach(m -> b.put(m.toByteArray()));
        return b.array();
    }

    public boolean hasMethod(String calledMethodId) {
        return this.methods.containsKey(calledMethodId);
    }

    public NeoMethod getMethod(String calledMethodId) {
        return this.methods.get(calledMethodId);
    }
}

