/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.script.OpCode;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ArraysConverter
implements Converter {
    private static final int BYTE_ARRAY_TYPE_CODE = 8;

    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (opcode) {
            case NEWARRAY: 
            case ANEWARRAY: {
                if (ArraysConverter.isByteArrayInstantiation(insn)) {
                    insn = this.handleNewByteArray(insn, neoMethod);
                    break;
                }
                this.handleNewArray(insn, neoMethod);
                break;
            }
            case BASTORE: 
            case IASTORE: 
            case AASTORE: 
            case CASTORE: 
            case LASTORE: 
            case SASTORE: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.SETITEM));
                break;
            }
            case AALOAD: 
            case BALOAD: 
            case CALOAD: 
            case IALOAD: 
            case LALOAD: 
            case SALOAD: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICKITEM));
                break;
            }
            case PUTFIELD: {
                ArraysConverter.addSetItem(insn, neoMethod, compUnit);
                break;
            }
            case GETFIELD: {
                ArraysConverter.addGetField(insn, neoMethod, compUnit);
                break;
            }
            case MULTIANEWARRAY: {
                throw new CompilerException(neoMethod, String.format("JVM opcode %s is not supported.", opcode.name()));
            }
        }
        return insn;
    }

    private void handleNewArray(AbstractInsnNode insn, NeoMethod neoMethod) {
        StackItemType stackItemType = null;
        if (insn instanceof IntInsnNode) {
            IntInsnNode intInsn = (IntInsnNode)insn;
            switch (intInsn.operand) {
                case 4: {
                    stackItemType = StackItemType.BOOLEAN;
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    stackItemType = StackItemType.INTEGER;
                }
            }
        } else if (insn instanceof TypeInsnNode) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            stackItemType = Compiler.mapTypeToStackItemType(Type.getObjectType((String)typeInsn.desc));
        }
        if (stackItemType == StackItemType.ANY) {
            neoMethod.addInstruction(new NeoInstruction(OpCode.NEWARRAY));
        } else {
            neoMethod.addInstruction(new NeoInstruction(OpCode.NEWARRAY_T, new byte[]{stackItemType.byteValue()}));
        }
    }

    private AbstractInsnNode handleNewByteArray(AbstractInsnNode insn, NeoMethod neoMethod) {
        BigInteger arraySize = this.extractPushedNumber(neoMethod.getLastInstruction());
        if (arraySize == null) {
            neoMethod.addInstruction(new NeoInstruction(OpCode.NEWBUFFER));
            return insn;
        }
        byte[] bytes = new byte[arraySize.intValueExact()];
        while (this.settingOfArrayElementFollows(insn)) {
            insn = insn.getNext().getNext();
            int idx = ArraysConverter.getPushedByte(insn, neoMethod);
            insn = insn.getNext();
            int value = ArraysConverter.getPushedByte(insn, neoMethod);
            bytes[idx] = (byte)value;
            insn = insn.getNext();
        }
        neoMethod.replaceLastInstruction(Compiler.buildPushDataInsn(bytes));
        neoMethod.addInstruction(new NeoInstruction(OpCode.CONVERT, new byte[]{StackItemType.BUFFER.byteValue()}));
        return insn;
    }

    private boolean settingOfArrayElementFollows(AbstractInsnNode insn) {
        if (!this.nextInsnIsOpCode(insn, JVMOpcode.DUP)) {
            return false;
        }
        if (!this.nextInsnIsPushByte(insn = insn.getNext())) {
            return false;
        }
        if (!this.nextInsnIsPushByte(insn = insn.getNext())) {
            return false;
        }
        insn = insn.getNext();
        return this.nextInsnIsOpCode(insn, JVMOpcode.BASTORE);
    }

    private boolean nextInsnIsOpCode(AbstractInsnNode insn, JVMOpcode opcode) {
        if (insn.getNext() == null) {
            return false;
        }
        return insn.getNext().getOpcode() == opcode.getOpcode();
    }

    private boolean nextInsnIsPushByte(AbstractInsnNode insn) {
        if (insn.getNext() == null) {
            return false;
        }
        return (insn = insn.getNext()).getOpcode() >= JVMOpcode.ICONST_0.getOpcode() && insn.getOpcode() <= JVMOpcode.ICONST_5.getOpcode() || insn.getOpcode() == JVMOpcode.BIPUSH.getOpcode();
    }

    private static int getPushedByte(AbstractInsnNode insn, NeoMethod neoMethod) {
        if (insn.getOpcode() >= JVMOpcode.ICONST_0.getOpcode() && insn.getOpcode() <= JVMOpcode.ICONST_5.getOpcode()) {
            return insn.getOpcode() - JVMOpcode.ICONST_0.getOpcode();
        }
        if (insn.getOpcode() == JVMOpcode.BIPUSH.getOpcode()) {
            return ((IntInsnNode)insn).operand;
        }
        throw new CompilerException(neoMethod, String.format("Unexpected instruction with opcode %s.", insn.getOpcode()));
    }

    private static boolean isByteArrayInstantiation(AbstractInsnNode insn) {
        return insn instanceof IntInsnNode && ((IntInsnNode)insn).operand == 8;
    }

    private BigInteger extractPushedNumber(NeoInstruction insn) {
        if (insn.getOpcode().getCode() <= OpCode.PUSHINT256.getCode()) {
            return BigIntegers.fromLittleEndianByteArray((byte[])insn.getOperand());
        }
        if (insn.getOpcode().getCode() >= OpCode.PUSHM1.getCode() && insn.getOpcode().getCode() <= OpCode.PUSH16.getCode()) {
            return BigInteger.valueOf(insn.getOpcode().getCode() - OpCode.PUSHM1.getCode() - 1);
        }
        return null;
    }

    private static void addSetItem(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        int idx = AsmHelper.getFieldIndex(fieldInsn, compUnit);
        Compiler.addPushNumber(idx, neoMethod);
        neoMethod.addInstruction(new NeoInstruction(OpCode.SWAP));
        neoMethod.addInstruction(new NeoInstruction(OpCode.SETITEM));
    }

    private static void addGetField(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        int idx = AsmHelper.getFieldIndex(fieldInsn, compUnit);
        Compiler.addPushNumber(idx, neoMethod);
        neoMethod.addInstruction(new NeoInstruction(OpCode.PICKITEM));
    }
}

