/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoJumpInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.script.OpCode;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

public class JumpsConverter
implements Converter {
    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (opcode) {
            case IF_ACMPEQ: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.EQUAL));
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIF_L);
                break;
            }
            case IF_ACMPNE: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.NOTEQUAL));
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIF_L);
                break;
            }
            case IF_ICMPEQ: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPEQ_L);
                break;
            }
            case IF_ICMPNE: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPNE_L);
                break;
            }
            case IF_ICMPLT: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPLT_L);
                break;
            }
            case IF_ICMPGT: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPGT_L);
                break;
            }
            case IF_ICMPLE: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPLE_L);
                break;
            }
            case IF_ICMPGE: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPGE_L);
                break;
            }
            case IFEQ: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIFNOT_L);
                break;
            }
            case IFNULL: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.ISNULL));
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIF_L);
                break;
            }
            case IFNE: {
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIF_L);
                break;
            }
            case IFNONNULL: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.ISNULL));
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPIFNOT_L);
                break;
            }
            case IFLT: {
                Compiler.addPushNumber(0L, neoMethod);
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPLT_L);
                break;
            }
            case IFLE: {
                Compiler.addPushNumber(0L, neoMethod);
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPLE_L);
                break;
            }
            case IFGT: {
                Compiler.addPushNumber(0L, neoMethod);
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPGT_L);
                break;
            }
            case IFGE: {
                Compiler.addPushNumber(0L, neoMethod);
                JumpsConverter.addJumpInstruction(neoMethod, insn, OpCode.JMPGE_L);
                break;
            }
            case LCMP: {
                insn = JumpsConverter.handleLongComparison(neoMethod, insn);
                break;
            }
            case GOTO: 
            case GOTO_W: {
                neoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMP_L, ((JumpInsnNode)insn).label.getLabel()));
                break;
            }
            case LOOKUPSWITCH: {
                JumpsConverter.handleLookupSwitch(neoMethod, insn);
                break;
            }
            case TABLESWITCH: {
                JumpsConverter.handleTableSwitch(neoMethod, insn);
                break;
            }
            case JSR: 
            case RET: 
            case JSR_W: {
                throw new CompilerException(neoMethod, String.format("JVM opcode %s is not supported.", opcode.name()));
            }
        }
        return insn;
    }

    private static void addJumpInstruction(NeoMethod neoMethod, AbstractInsnNode insn, OpCode jmpOpcode) {
        Label jmpLabel = ((JumpInsnNode)insn).label.getLabel();
        neoMethod.addInstruction(new NeoJumpInstruction(jmpOpcode, jmpLabel));
    }

    private static AbstractInsnNode handleLongComparison(NeoMethod neoMethod, AbstractInsnNode insn) {
        JumpInsnNode jumpInsn = (JumpInsnNode)insn.getNext();
        JVMOpcode jvmOpcode = JVMOpcode.get(jumpInsn.getOpcode());
        assert (jvmOpcode != null) : "Opcode of of jump instruction was not set.";
        switch (jvmOpcode) {
            case IFEQ: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPEQ_L);
                break;
            }
            case IFNE: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPNE_L);
                break;
            }
            case IFLT: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPLT_L);
                break;
            }
            case IFGT: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPGT_L);
                break;
            }
            case IFLE: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPLE_L);
                break;
            }
            case IFGE: {
                JumpsConverter.addJumpInstruction(neoMethod, (AbstractInsnNode)jumpInsn, OpCode.JMPGE_L);
                break;
            }
            default: {
                throw new CompilerException(neoMethod, String.format("Unexpected JVM opcode %s following long comparison (%s)", jvmOpcode.name(), JVMOpcode.LCMP.name()));
            }
        }
        return jumpInsn;
    }

    private static void handleLookupSwitch(NeoMethod neoMethod, AbstractInsnNode insn) {
        LookupSwitchInsnNode switchNode = (LookupSwitchInsnNode)insn;
        for (int i = 0; i < switchNode.keys.size(); ++i) {
            int key = (Integer)switchNode.keys.get(i);
            JumpsConverter.processCase(i, key, switchNode.labels, switchNode.dflt.getLabel(), neoMethod);
        }
    }

    private static void processCase(int i, int key, List<LabelNode> labels, Label defaultLabel, NeoMethod neoMethod) {
        Label nextCaseLabel;
        boolean isLastCase = JumpsConverter.isLastCase(i, labels, defaultLabel);
        if (isLastCase) {
            nextCaseLabel = defaultLabel;
        } else {
            nextCaseLabel = new Label();
            neoMethod.addInstruction(new NeoInstruction(OpCode.DUP));
        }
        Compiler.addPushNumber(key, neoMethod);
        neoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMPNE_L, nextCaseLabel));
        if (!isLastCase) {
            neoMethod.addInstruction(new NeoInstruction(OpCode.DROP));
        }
        Label jmpLabel = labels.get(i).getLabel();
        neoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMP_L, jmpLabel));
        neoMethod.setCurrentLabel(nextCaseLabel);
    }

    private static boolean isLastCase(int i, List<LabelNode> labelNodes, Label defaultLbl) {
        assert (i < labelNodes.size() && i >= 0) : "Index was outside of the list of label nodes.";
        if (i == labelNodes.size() - 1 && labelNodes.get(i).getLabel() != defaultLbl) {
            return true;
        }
        while (i < labelNodes.size()) {
            LabelNode labelNode = labelNodes.get(i);
            if (labelNode.getLabel() != defaultLbl) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void handleTableSwitch(NeoMethod neoMethod, AbstractInsnNode insn) {
        TableSwitchInsnNode switchNode = (TableSwitchInsnNode)insn;
        for (int i = 0; i < switchNode.labels.size(); ++i) {
            if (((LabelNode)switchNode.labels.get(i)).getLabel() == switchNode.dflt.getLabel()) continue;
            int key = switchNode.min + i;
            JumpsConverter.processCase(i, key, switchNode.labels, switchNode.dflt.getLabel(), neoMethod);
        }
    }
}

