/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.LocalVariableHelper;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoJumpInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.contract.NefFile;
import io.neow3j.devpack.StringLiteralHelper;
import io.neow3j.devpack.annotations.ContractHash;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.devpack.annotations.Syscall;
import io.neow3j.devpack.contracts.ContractInterface;
import io.neow3j.script.OpCode;
import io.neow3j.types.CallFlags;
import io.neow3j.types.Hash160;
import io.neow3j.utils.AddressUtils;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MethodsConverter
implements Converter {
    private static final List<String> PRIMITIVE_TYPE_CAST_METHODS = Arrays.asList("intValue", "longValue", "byteValue", "shortValue", "booleanValue", "charValue");
    private static final List<String> PRIMITIVE_TYPE_WRAPPER_CLASSES = Arrays.asList("java/lang/Integer", "java/lang/Long", "java/lang/Byte", "java/lang/Short", "java/lang/Boolean", "java/lang/Character");
    private static final String VALUEOF_METHOD_NAME = "valueOf";
    private static final String HASH_CODE_METHOD_NAME = "hashCode";
    private static final String ADDRESS_TO_SCRIPTHASH_METHOD_NAME = "addressToScriptHash";
    private static final String HEX_TO_BYTES_METHOD_NAME = "hexToBytes";
    private static final String STRING_TO_INT_METHOD_NAME = "stringToInt";
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final String LENGTH_METHOD_NAME = "length";
    private static final String GET_CONTRACT_HASH_METHOD_NAME = "getHash";

    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (opcode) {
            case RETURN: 
            case IRETURN: 
            case ARETURN: 
            case LRETURN: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.RET));
                break;
            }
            case INVOKESTATIC: 
            case INVOKEVIRTUAL: 
            case INVOKESPECIAL: {
                insn = MethodsConverter.handleInvoke(insn, neoMethod, compUnit);
                break;
            }
            case INVOKEINTERFACE: 
            case INVOKEDYNAMIC: {
                throw new CompilerException(neoMethod, String.format("JVM opcode %s is not supported.", opcode.name()));
            }
        }
        return insn;
    }

    public static AbstractInsnNode handleInvoke(AbstractInsnNode insn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        MethodInsnNode methodInsn = (MethodInsnNode)insn;
        ClassNode ownerClass = AsmHelper.getAsmClassForInternalName(methodInsn.owner, compUnit.getClassLoader());
        Optional<MethodNode> calledAsmMethod = AsmHelper.getMethodNode(methodInsn, ownerClass);
        ClassNode topLevelOwnerClass = ownerClass;
        while (!calledAsmMethod.isPresent()) {
            if (ownerClass.superName == null) {
                throw new CompilerException(callingNeoMethod, String.format("Couldn't find method '%s' on its owner class %s and its super classes.", methodInsn.name, ClassUtils.getFullyQualifiedNameForInternalName((String)ownerClass.name)));
            }
            ownerClass = AsmHelper.getAsmClassForInternalName(ownerClass.superName, compUnit.getClassLoader());
            calledAsmMethod = AsmHelper.getMethodNode(methodInsn, ownerClass);
        }
        if (MethodsConverter.hasSyscallAnnotation(calledAsmMethod.get())) {
            Compiler.addSyscall(calledAsmMethod.get(), callingNeoMethod);
        } else if (MethodsConverter.hasInstructionAnnotation(calledAsmMethod.get())) {
            Compiler.addInstructionsFromAnnotation(calledAsmMethod.get(), callingNeoMethod);
        } else if (MethodsConverter.isContractCall(topLevelOwnerClass, compUnit)) {
            MethodsConverter.addContractCall(calledAsmMethod.get(), callingNeoMethod, topLevelOwnerClass, compUnit);
        } else if (MethodsConverter.isStringLiteralConverter(calledAsmMethod.get(), ownerClass)) {
            MethodsConverter.handleStringLiteralsConverter(calledAsmMethod.get(), callingNeoMethod);
        } else if (MethodsConverter.isStringEqualsMethodCall((AbstractInsnNode)methodInsn)) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.EQUAL));
        } else {
            return MethodsConverter.handleMethodCall(callingNeoMethod, ownerClass, calledAsmMethod.get(), methodInsn, compUnit);
        }
        return insn;
    }

    private static AbstractInsnNode handleMethodCall(NeoMethod callingNeoMethod, ClassNode owner, MethodNode calledAsmMethod, MethodInsnNode methodInsn, CompilationUnit compUnit) throws IOException {
        String calledMethodId = NeoMethod.getMethodId(calledAsmMethod, owner);
        if (!compUnit.getNeoModule().hasMethod(calledMethodId)) {
            return MethodsConverter.handleUncachedMethodCall(callingNeoMethod, owner, calledAsmMethod, methodInsn, compUnit);
        }
        NeoMethod calledNeoMethod = compUnit.getNeoModule().getMethod(calledMethodId);
        Compiler.addReverseArguments(calledAsmMethod, callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.CALL_L, new byte[4]).setExtra(calledNeoMethod));
        return methodInsn;
    }

    private static AbstractInsnNode handleUncachedMethodCall(NeoMethod callingNeoMethod, ClassNode owner, MethodNode calledAsmMethod, MethodInsnNode methodInsn, CompilationUnit compUnit) throws IOException {
        if (MethodsConverter.isPrimitiveTypeCast(calledAsmMethod, owner)) {
            return methodInsn;
        }
        if (MethodsConverter.isStringSwitch(owner, calledAsmMethod, methodInsn)) {
            return MethodsConverter.handleStringSwitch(callingNeoMethod, methodInsn);
        }
        if (MethodsConverter.isStringLengthCall(methodInsn)) {
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.SIZE));
            return methodInsn;
        }
        NeoMethod calledNeoMethod = new NeoMethod(calledAsmMethod, owner);
        compUnit.getNeoModule().addMethod(calledNeoMethod);
        calledNeoMethod.initialize(compUnit);
        calledNeoMethod.convert(compUnit);
        Compiler.addReverseArguments(calledAsmMethod, callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.CALL_L, new byte[4]).setExtra(calledNeoMethod));
        return methodInsn;
    }

    private static boolean isStringLengthCall(MethodInsnNode methodInsn) {
        return methodInsn.owner.equals(Type.getInternalName(String.class)) && methodInsn.name.equals(LENGTH_METHOD_NAME);
    }

    private static boolean isStringSwitch(ClassNode owner, MethodNode calledAsmMethod, MethodInsnNode methodInsn) {
        return calledAsmMethod.name.equals(HASH_CODE_METHOD_NAME) && owner.name.equals(Type.getInternalName(String.class)) && methodInsn.getNext() instanceof LookupSwitchInsnNode;
    }

    private static boolean isPrimitiveTypeCast(MethodNode calledAsmMethod, ClassNode owner) {
        boolean isConversionFromPrimitiveType = calledAsmMethod.name.equals(VALUEOF_METHOD_NAME);
        boolean isConversionToPrimitiveType = PRIMITIVE_TYPE_CAST_METHODS.contains(calledAsmMethod.name);
        boolean isOwnerPrimitiveTypeWrapper = PRIMITIVE_TYPE_WRAPPER_CLASSES.contains(owner.name);
        return (isConversionFromPrimitiveType || isConversionToPrimitiveType) && isOwnerPrimitiveTypeWrapper;
    }

    public static boolean isStringLiteralConverter(MethodNode methodNode, ClassNode owner) {
        return owner.name.equals(Type.getInternalName(StringLiteralHelper.class)) && (methodNode.name.equals(ADDRESS_TO_SCRIPTHASH_METHOD_NAME) || methodNode.name.equals(HEX_TO_BYTES_METHOD_NAME) || methodNode.name.equals(STRING_TO_INT_METHOD_NAME));
    }

    private static void handleStringLiteralsConverter(MethodNode methodNode, NeoMethod callingNeoMethod) {
        NeoInstruction lastNeoInsn = callingNeoMethod.getLastInstruction();
        if (!(lastNeoInsn.getOpcode().equals((Object)OpCode.PUSHDATA1) || lastNeoInsn.getOpcode().equals((Object)OpCode.PUSHDATA2) || lastNeoInsn.getOpcode().equals((Object)OpCode.PUSHDATA4))) {
            throw new CompilerException(callingNeoMethod, "Static field converter methods can only be applied to constant string literals.");
        }
        String stringLiteral = new String(lastNeoInsn.getOperand(), StandardCharsets.UTF_8);
        NeoInstruction newInsn = null;
        if (methodNode.name.equals(ADDRESS_TO_SCRIPTHASH_METHOD_NAME)) {
            if (!AddressUtils.isValidAddress((String)stringLiteral)) {
                throw new CompilerException(callingNeoMethod, String.format("Invalid address '%s' used in static field initialization.", stringLiteral));
            }
            byte[] scriptHash = AddressUtils.addressToScriptHash((String)stringLiteral);
            newInsn = Compiler.buildPushDataInsn(ArrayUtils.reverseArray((byte[])scriptHash));
        } else if (methodNode.name.equals(HEX_TO_BYTES_METHOD_NAME)) {
            if (!Numeric.isValidHexString((String)stringLiteral)) {
                throw new CompilerException(callingNeoMethod, String.format("Invalid hex string ('%s') used in static field initialization.", stringLiteral));
            }
            byte[] bytes = Numeric.hexStringToByteArray((String)stringLiteral);
            newInsn = Compiler.buildPushDataInsn(bytes);
        } else if (methodNode.name.equals(STRING_TO_INT_METHOD_NAME)) {
            try {
                newInsn = Compiler.buildPushNumberInstruction(new BigInteger(stringLiteral));
            }
            catch (NumberFormatException e) {
                throw new CompilerException(callingNeoMethod, String.format("Invalid number string ('%s') used in static field initialization.", stringLiteral));
            }
        }
        callingNeoMethod.replaceLastInstruction(newInsn);
    }

    public static boolean hasSyscallAnnotation(MethodNode asmMethod) {
        return AsmHelper.hasAnnotations(asmMethod, Syscall.Syscalls.class, Syscall.class);
    }

    private static boolean isContractCall(ClassNode owner, CompilationUnit compUnit) throws IOException {
        while (!ClassUtils.getFullyQualifiedNameForInternalName((String)owner.superName).equals(Object.class.getCanonicalName())) {
            if (ClassUtils.getFullyQualifiedNameForInternalName((String)owner.superName).equals(ContractInterface.class.getCanonicalName())) {
                return true;
            }
            owner = AsmHelper.getAsmClassForInternalName(owner.superName, compUnit.getClassLoader());
        }
        return false;
    }

    private static boolean hasInstructionAnnotation(MethodNode asmMethod) {
        return AsmHelper.hasAnnotations(asmMethod, Instruction.Instructions.class, Instruction.class);
    }

    private static AbstractInsnNode handleStringSwitch(NeoMethod callingNeoMethod, MethodInsnNode methodInsn) {
        callingNeoMethod.removeLastInstruction();
        callingNeoMethod.removeLastInstruction();
        callingNeoMethod.removeLastInstruction();
        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)methodInsn.getNext();
        AbstractInsnNode insn = lookupSwitchInsn.getNext();
        TableSwitchInsnNode tableSwitchInsn = null;
        LookupSwitchInsnNode secondLookupSwitchInsn = null;
        try {
            tableSwitchInsn = (TableSwitchInsnNode)MethodsConverter.skipToInstructionType(insn, 11, callingNeoMethod);
        }
        catch (CompilerException e) {
            try {
                secondLookupSwitchInsn = (LookupSwitchInsnNode)MethodsConverter.skipToInstructionType(insn, 12, callingNeoMethod);
            }
            catch (CompilerException i) {
                throw new CompilerException(callingNeoMethod, "Error converting a string switch-case statement.");
            }
        }
        for (int i = 0; i < lookupSwitchInsn.labels.size(); ++i) {
            insn = MethodsConverter.skipToInstructionType(insn, 2, callingNeoMethod);
            LocalVariableHelper.addLoadLocalVariable(((VarInsnNode)insn).var, callingNeoMethod);
            insn = insn.getNext();
            Compiler.addLoadConstant(insn, callingNeoMethod);
            insn = insn.getNext();
            assert (MethodsConverter.isStringEqualsMethodCall(insn));
            JumpInsnNode jumpInsn = (JumpInsnNode)insn.getNext();
            assert (jumpInsn.getOpcode() == JVMOpcode.IFEQ.getOpcode());
            InsnNode branchNumberInsn = (InsnNode)jumpInsn.getNext();
            int branchNr = branchNumberInsn.getOpcode() - 3;
            insn = branchNumberInsn.getNext();
            assert (insn.getType() == 2);
            callingNeoMethod.addInstruction(new NeoInstruction(OpCode.EQUAL));
            if (tableSwitchInsn != null) {
                callingNeoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMPIF_L, ((LabelNode)tableSwitchInsn.labels.get(branchNr)).getLabel()));
                continue;
            }
            callingNeoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMPIF_L, ((LabelNode)secondLookupSwitchInsn.labels.get(branchNr)).getLabel()));
        }
        if (tableSwitchInsn != null) {
            callingNeoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMP_L, tableSwitchInsn.dflt.getLabel()));
            return tableSwitchInsn;
        }
        callingNeoMethod.addInstruction(new NeoJumpInstruction(OpCode.JMP_L, secondLookupSwitchInsn.dflt.getLabel()));
        return secondLookupSwitchInsn;
    }

    private static boolean isStringEqualsMethodCall(AbstractInsnNode insn) {
        if (insn.getType() == 5 && insn.getOpcode() == JVMOpcode.INVOKEVIRTUAL.getOpcode()) {
            MethodInsnNode equalsCallInsn = (MethodInsnNode)insn;
            return equalsCallInsn.name.equals(EQUALS_METHOD_NAME) && equalsCallInsn.owner.equals(Type.getInternalName(String.class));
        }
        return false;
    }

    private static void addContractCall(MethodNode calledAsmMethod, NeoMethod callingNeoMethod, ClassNode owner, CompilationUnit compUnit) {
        Hash160 scriptHash;
        if (!AsmHelper.hasAnnotations(owner, ContractHash.class)) {
            throw new CompilerException(callingNeoMethod, "Error trying to call a method on a contract interface that does not have a contract hash specified. Make sure that there is a " + ContractHash.class.getCanonicalName() + " annotation on the contract interface you are calling.");
        }
        AnnotationNode annotation = AsmHelper.getAnnotationNode(owner, ContractHash.class).get();
        try {
            scriptHash = new Hash160((String)annotation.values.get(1));
        }
        catch (IllegalArgumentException e) {
            throw new CompilerException(owner, String.format("Script hash '%s' of the contract class '%s' does not have the length of a correct script hash.", annotation.values.get(1), ClassUtils.getClassNameForInternalName((String)owner.name)));
        }
        if (calledAsmMethod.name.equals(GET_CONTRACT_HASH_METHOD_NAME)) {
            callingNeoMethod.addInstruction(Compiler.buildPushDataInsn(ArrayUtils.reverseArray((byte[])scriptHash.toArray())));
            return;
        }
        int nrOfParams = Type.getType((String)calledAsmMethod.desc).getArgumentTypes().length;
        boolean hasReturnValue = !Type.getMethodType((String)calledAsmMethod.desc).getReturnType().getClassName().equals(Void.TYPE.getTypeName());
        NefFile.MethodToken token = new NefFile.MethodToken(scriptHash, calledAsmMethod.name, nrOfParams, hasReturnValue, CallFlags.ALL);
        int idx = compUnit.getNeoModule().addMethodToken(token);
        byte[] idxBytes = ArrayUtils.getFirstNBytes((byte[])ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(idx).array(), (int)2);
        Compiler.addReverseArguments(callingNeoMethod, nrOfParams);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.CALLT, idxBytes));
    }

    private static AbstractInsnNode skipToInstructionType(AbstractInsnNode insn, int type, NeoMethod neoMethod) {
        while (insn.getNext() != null) {
            if ((insn = insn.getNext()).getType() != type) continue;
            return insn;
        }
        throw new CompilerException(neoMethod, String.format("Tried to skip to an instruction of type %d but reached the end of the method.", type));
    }
}

