/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.AsmHelper;
import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.Compiler;
import io.neow3j.compiler.CompilerException;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.LocalVariableHelper;
import io.neow3j.compiler.NeoEvent;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.devpack.ByteString;
import io.neow3j.devpack.InteropInterface;
import io.neow3j.devpack.Iterator;
import io.neow3j.devpack.Map;
import io.neow3j.devpack.annotations.Instruction;
import io.neow3j.devpack.annotations.Syscall;
import io.neow3j.script.InteropService;
import io.neow3j.script.OpCode;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ClassUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObjectsConverter
implements Converter {
    private static final String APPEND_METHOD_NAME = "append";
    private static final String TOSTRING_METHOD_NAME = "toString";

    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (Objects.requireNonNull(opcode)) {
            case PUTSTATIC: {
                ObjectsConverter.addStoreStaticField(insn, neoMethod);
                break;
            }
            case GETSTATIC: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (Compiler.isEvent(AsmHelper.getInternalNameForDescriptor(fieldInsn.desc))) {
                    insn = ObjectsConverter.convertEvent(fieldInsn, neoMethod, compUnit);
                    break;
                }
                ObjectsConverter.addLoadStaticField(fieldInsn, neoMethod);
                break;
            }
            case CHECKCAST: {
                break;
            }
            case NEW: {
                insn = ObjectsConverter.handleNew(insn, neoMethod, compUnit);
                break;
            }
            case ARRAYLENGTH: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.SIZE));
                break;
            }
            case INSTANCEOF: {
                this.handleInstanceOf((TypeInsnNode)insn, neoMethod);
            }
        }
        return insn;
    }

    private void handleInstanceOf(TypeInsnNode typeInsn, NeoMethod neoMethod) {
        Type type = typeInsn.desc.contains("/") ? Type.getType((String)("L" + typeInsn.desc + ";")) : Type.getType((String)typeInsn.desc);
        if (!this.isSupportedInstanceOfType(type)) {
            throw new CompilerException(neoMethod, String.format("The type '%s' is not supported for the instanceof operation.", ClassUtils.getFullyQualifiedNameForInternalName((String)type.getInternalName())));
        }
        StackItemType stackItemType = Compiler.mapTypeToStackItemType(type);
        if (stackItemType.equals((Object)StackItemType.BOOLEAN)) {
            stackItemType = StackItemType.INTEGER;
        }
        neoMethod.addInstruction(new NeoInstruction(OpCode.ISTYPE, new byte[]{stackItemType.byteValue()}));
    }

    private boolean isSupportedInstanceOfType(Type type) {
        String typeName = type.getClassName();
        return typeName.equals(String.class.getTypeName()) || typeName.equals(ByteString.class.getTypeName()) || typeName.equals(Integer.class.getTypeName()) || typeName.equals(Integer.TYPE.getTypeName()) || typeName.equals(Long.class.getTypeName()) || typeName.equals(Long.TYPE.getTypeName()) || typeName.equals(Byte.class.getTypeName()) || typeName.equals(Byte.TYPE.getTypeName()) || typeName.equals(Short.class.getTypeName()) || typeName.equals(Short.TYPE.getTypeName()) || typeName.equals(Character.class.getTypeName()) || typeName.equals(Character.TYPE.getTypeName()) || typeName.equals(Boolean.class.getTypeName()) || typeName.equals(Boolean.TYPE.getTypeName()) || typeName.equals(Byte[].class.getTypeName()) || typeName.equals(byte[].class.getTypeName()) || typeName.equals(Map.class.getTypeName()) || typeName.equals(io.neow3j.devpack.List.class.getTypeName()) || typeName.equals(InteropInterface.class.getTypeName()) || typeName.equals(Iterator.Struct.class.getTypeName());
    }

    public static void addLoadStaticField(FieldInsnNode fieldInsn, NeoMethod neoMethod) {
        int idx = AsmHelper.getFieldIndex(fieldInsn, neoMethod.getOwnerClass());
        neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(idx, OpCode.LDSFLD));
    }

    public static void addStoreStaticField(AbstractInsnNode insn, NeoMethod neoMethod) {
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        int idx = AsmHelper.getFieldIndex(fieldInsn, neoMethod.getOwnerClass());
        neoMethod.addInstruction(LocalVariableHelper.buildStoreOrLoadVariableInsn(idx, OpCode.STSFLD));
    }

    public static AbstractInsnNode handleNew(AbstractInsnNode insn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        TypeInsnNode typeInsn = (TypeInsnNode)insn;
        assert (typeInsn.getNext().getOpcode() == JVMOpcode.DUP.getOpcode()) : "Expected DUP after NEW but got other instructions";
        if (ObjectsConverter.isNewStringBuilder(typeInsn)) {
            return ObjectsConverter.handleStringConcatenation(typeInsn, callingNeoMethod, compUnit);
        }
        if (ObjectsConverter.isNewThrowable(typeInsn, compUnit)) {
            return ObjectsConverter.handleNewThrowable(typeInsn, callingNeoMethod, compUnit);
        }
        ClassNode owner = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        MethodInsnNode ctorMethodInsn = Compiler.skipToCtorCall(typeInsn.getNext(), owner);
        MethodNode ctorMethod = AsmHelper.getMethodNode(ctorMethodInsn, owner).orElseThrow(() -> new CompilerException(callingNeoMethod, String.format("Couldn't find constructor '%s' on class '%s'.", ctorMethodInsn.name, ClassUtils.getClassNameForInternalName((String)owner.name))));
        if (ctorMethod.invisibleAnnotations == null || ctorMethod.invisibleAnnotations.size() == 0) {
            return ObjectsConverter.convertConstructorCall(typeInsn, ctorMethod, owner, callingNeoMethod, compUnit);
        }
        insn = insn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, owner.name)) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        if (AsmHelper.hasAnnotations(ctorMethod, Syscall.class, Syscall.Syscalls.class)) {
            Compiler.addConstructorSyscall(ctorMethod, callingNeoMethod);
        } else if (AsmHelper.hasAnnotations(ctorMethod, Instruction.class, Instruction.Instructions.class)) {
            Compiler.addInstructionsFromAnnotation(ctorMethod, callingNeoMethod);
        }
        return insn;
    }

    private static boolean isNewStringBuilder(TypeInsnNode typeInsn) {
        return typeInsn.desc.equals(Type.getInternalName(StringBuilder.class));
    }

    private static boolean isNewThrowable(TypeInsnNode typeInsn, CompilationUnit compUnit) throws IOException {
        ClassNode type = AsmHelper.getAsmClassForInternalName(typeInsn.desc, compUnit.getClassLoader());
        if (ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(Throwable.class.getCanonicalName())) {
            return true;
        }
        while (type.superName != null) {
            type = AsmHelper.getAsmClassForInternalName(type.superName, compUnit.getClassLoader());
            if (!ClassUtils.getFullyQualifiedNameForInternalName((String)type.name).equals(Throwable.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static AbstractInsnNode handleNewThrowable(TypeInsnNode typeInsn, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        if (!Exception.class.getCanonicalName().equals(ClassUtils.getFullyQualifiedNameForInternalName((String)typeInsn.desc))) {
            throw new CompilerException(callingNeoMethod, String.format("Contract uses exception of type %s but only %s is allowed.", ClassUtils.getFullyQualifiedNameForInternalName((String)typeInsn.desc), Exception.class.getCanonicalName()));
        }
        AbstractInsnNode insn = typeInsn.getNext().getNext();
        while (!Compiler.isCallToCtor(insn, Type.getType(Exception.class).getInternalName())) {
            insn = Compiler.handleInsn(insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        Type[] argTypes = Type.getType((String)((MethodInsnNode)insn).desc).getArgumentTypes();
        if (argTypes.length > 1) {
            throw new CompilerException(callingNeoMethod, String.format("An exception thrown in a contract can either take no arguments or a String argument. You provided %d arguments.", argTypes.length));
        }
        if (argTypes.length == 1 && !ClassUtils.getFullyQualifiedNameForInternalName((String)argTypes[0].getInternalName()).equals(String.class.getCanonicalName())) {
            throw new CompilerException(callingNeoMethod, "An exception thrown in a contract can either take no arguments or a String argument. You provided a non-string argument.");
        }
        if (argTypes.length == 0) {
            callingNeoMethod.addInstruction(Compiler.buildPushDataInsn("error"));
        }
        return insn;
    }

    private static AbstractInsnNode handleStringConcatenation(TypeInsnNode typeInsnNode, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        AbstractInsnNode insn = typeInsnNode.getNext().getNext().getNext();
        boolean isFirstCall = true;
        while (insn != null) {
            if (ObjectsConverter.isCallToStringBuilderAppend(insn)) {
                if (!isFirstCall) {
                    neoMethod.addInstruction(new NeoInstruction(OpCode.CAT));
                }
                isFirstCall = false;
                insn = insn.getNext();
                continue;
            }
            if (ObjectsConverter.isCallToStringBuilderToString(insn)) {
                neoMethod.addInstruction(new NeoInstruction(OpCode.CONVERT, new byte[]{StackItemType.BYTE_STRING.byteValue()}));
                break;
            }
            if (ObjectsConverter.isCallToAnyStringBuilderMethod(insn)) {
                throw new CompilerException(neoMethod, String.format("Only 'append()' and 'toString()' are supported for StringBuilder, but '%s' was called", ((MethodInsnNode)insn).name));
            }
            insn = Compiler.handleInsn(insn, neoMethod, compUnit);
            insn = insn.getNext();
        }
        if (insn == null) {
            throw new CompilerException(neoMethod, "Expected to find ScriptBuilder.toString() but reached end of method.");
        }
        return insn;
    }

    private static boolean isCallToStringBuilderAppend(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class)) && ((MethodInsnNode)insn).name.equals(APPEND_METHOD_NAME);
    }

    private static boolean isCallToStringBuilderToString(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class)) && ((MethodInsnNode)insn).name.equals(TOSTRING_METHOD_NAME);
    }

    private static boolean isCallToAnyStringBuilderMethod(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).owner.equals(Type.getInternalName(StringBuilder.class));
    }

    private static AbstractInsnNode convertConstructorCall(TypeInsnNode typeInsn, MethodNode ctorMethod, ClassNode owner, NeoMethod callingNeoMethod, CompilationUnit compUnit) throws IOException {
        MethodInsnNode insn;
        NeoMethod calledNeoMethod;
        String ctorMethodId = NeoMethod.getMethodId(ctorMethod, owner);
        if (compUnit.getNeoModule().hasMethod(ctorMethodId)) {
            calledNeoMethod = compUnit.getNeoModule().getMethod(ctorMethodId);
        } else {
            calledNeoMethod = new NeoMethod(ctorMethod, owner);
            compUnit.getNeoModule().addMethod(calledNeoMethod);
            calledNeoMethod.initialize(compUnit);
            insn = Compiler.skipToSuperCtorCall(ctorMethod, owner);
            for (insn = insn.getNext(); insn != null; insn = insn.getNext()) {
                insn = Compiler.handleInsn((AbstractInsnNode)insn, calledNeoMethod, compUnit);
            }
        }
        Compiler.addPushNumber(owner.fields.size(), callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.NEWARRAY));
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.DUP));
        insn = typeInsn.getNext().getNext();
        while (!Compiler.isCallToCtor((AbstractInsnNode)insn, owner.name)) {
            insn = Compiler.handleInsn((AbstractInsnNode)insn, callingNeoMethod, compUnit);
            insn = insn.getNext();
        }
        Compiler.addReverseArguments(ctorMethod, callingNeoMethod);
        callingNeoMethod.addInstruction(new NeoInstruction(OpCode.CALL_L, new byte[4]).setExtra(calledNeoMethod));
        return insn;
    }

    private static AbstractInsnNode convertEvent(FieldInsnNode eventFieldInsn, NeoMethod neoMethod, CompilationUnit compUnit) throws IOException {
        String eventVariableName = eventFieldInsn.name;
        List<NeoEvent> events = compUnit.getNeoModule().getEvents();
        NeoEvent event = events.stream().filter(e -> eventVariableName.equals(e.getAsmVariable().name)).findFirst().orElseThrow(() -> new CompilerException(neoMethod, "Couldn't find triggered event in list of events."));
        AbstractInsnNode insn = eventFieldInsn.getNext();
        while (!ObjectsConverter.isMethodCallToEventSend(insn)) {
            insn = Compiler.handleInsn(insn, neoMethod, compUnit);
            insn = insn.getNext();
            assert (insn != null) : "Expected to find call to send() method of an event but reached the end of the instructions.";
        }
        Compiler.addReverseArguments(neoMethod, event.getNumberOfParams());
        Compiler.addPushNumber(event.getNumberOfParams(), neoMethod);
        neoMethod.addInstruction(new NeoInstruction(OpCode.PACK));
        neoMethod.addInstruction(Compiler.buildPushDataInsn(event.getDisplayName()));
        byte[] syscallHash = Numeric.hexStringToByteArray((String)InteropService.SYSTEM_RUNTIME_NOTIFY.getHash());
        neoMethod.addInstruction(new NeoInstruction(OpCode.SYSCALL, syscallHash));
        return insn;
    }

    private static boolean isMethodCallToEventSend(AbstractInsnNode insn) {
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)insn;
        return Compiler.isEvent(methodInsn.owner);
    }
}

