/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.compiler.converters;

import io.neow3j.compiler.CompilationUnit;
import io.neow3j.compiler.JVMOpcode;
import io.neow3j.compiler.NeoInstruction;
import io.neow3j.compiler.NeoMethod;
import io.neow3j.compiler.converters.Converter;
import io.neow3j.script.OpCode;
import org.objectweb.asm.tree.AbstractInsnNode;

public class StackManipulationConverter
implements Converter {
    @Override
    public AbstractInsnNode convert(AbstractInsnNode insn, NeoMethod neoMethod, CompilationUnit compUnit) {
        JVMOpcode opcode = JVMOpcode.get(insn.getOpcode());
        switch (opcode) {
            case NOP: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.NOP));
                break;
            }
            case DUP: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.DUP));
                break;
            }
            case DUP2: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.OVER));
                neoMethod.addInstruction(new NeoInstruction(OpCode.OVER));
                break;
            }
            case POP: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.DROP));
                break;
            }
            case POP2: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.DROP));
                neoMethod.addInstruction(new NeoInstruction(OpCode.DROP));
                break;
            }
            case SWAP: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.SWAP));
                break;
            }
            case DUP_X1: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.TUCK));
                break;
            }
            case DUP_X2: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.ROT));
                neoMethod.addInstruction(new NeoInstruction(OpCode.ROT));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH2));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICK));
                break;
            }
            case DUP2_X1: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.ROT));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH2));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICK));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH2));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICK));
                break;
            }
            case DUP2_X2: {
                neoMethod.addInstruction(new NeoInstruction(OpCode.ROT));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH3));
                neoMethod.addInstruction(new NeoInstruction(OpCode.ROLL));
                neoMethod.addInstruction(new NeoInstruction(OpCode.SWAP));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH3));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICK));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PUSH3));
                neoMethod.addInstruction(new NeoInstruction(OpCode.PICK));
            }
        }
        return insn;
    }
}

