/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol;

import io.neow3j.protocol.Neow3jConfig;
import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.core.JsonRpc2_0Neow3j;
import io.neow3j.protocol.core.Neo;
import io.neow3j.protocol.rx.Neow3jRx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ScheduledExecutorService;

public abstract class Neow3j
implements Neo,
Neow3jRx {
    private final Neow3jConfig config;

    protected Neow3j(Neow3jConfig config) {
        this.config = config;
    }

    public static Neow3j build(Neow3jService neow3jService) {
        return new JsonRpc2_0Neow3j(neow3jService, new Neow3jConfig());
    }

    public static Neow3j build(Neow3jService neow3jService, Neow3jConfig config) {
        return new JsonRpc2_0Neow3j(neow3jService, config);
    }

    public abstract void shutdown();

    public byte[] getNetworkMagicNumberBytes() throws IOException {
        if (this.config.getNetworkMagic() == null) {
            this.config.setNetworkMagic(this.getVersion().send().getVersion().getNetwork());
        }
        int networkMagicAsInt = (int)(this.config.getNetworkMagic() & 0xFFFFFFFFL);
        byte[] array = new byte[4];
        ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN).putInt(networkMagicAsInt);
        return array;
    }

    public long getNetworkMagicNumber() throws IOException {
        if (this.config.getNetworkMagic() == null) {
            this.config.setNetworkMagic(this.getVersion().send().getVersion().getNetwork());
        }
        return this.config.getNetworkMagic();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.config.getScheduledExecutorService();
    }

    public int getBlockInterval() {
        return this.config.getBlockInterval();
    }

    public int getPollingInterval() {
        return this.config.getPollingInterval();
    }

    public long getMaxValidUntilBlockIncrement() {
        return this.config.getMaxValidUntilBlockIncrement();
    }
}

