/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol;

import io.neow3j.protocol.Neow3jConfig;
import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.core.JsonRpc2_0Neow3j;
import io.neow3j.protocol.core.NeoExpress;
import io.neow3j.protocol.core.Request;
import io.neow3j.protocol.core.response.NeoExpressCreateCheckpoint;
import io.neow3j.protocol.core.response.NeoExpressCreateOracleResponseTx;
import io.neow3j.protocol.core.response.NeoExpressGetContractStorage;
import io.neow3j.protocol.core.response.NeoExpressGetNep17Contracts;
import io.neow3j.protocol.core.response.NeoExpressGetPopulatedBlocks;
import io.neow3j.protocol.core.response.NeoExpressListContracts;
import io.neow3j.protocol.core.response.NeoExpressListOracleRequests;
import io.neow3j.protocol.core.response.NeoExpressShutdown;
import io.neow3j.protocol.core.response.OracleResponse;
import io.neow3j.types.Hash160;
import java.util.Arrays;
import java.util.Collections;

public class Neow3jExpress
extends JsonRpc2_0Neow3j
implements NeoExpress {
    private Neow3jExpress(Neow3jService neow3jService, Neow3jConfig config) {
        super(neow3jService, config);
    }

    public static Neow3jExpress build(Neow3jService neow3jService) {
        return new Neow3jExpress(neow3jService, new Neow3jConfig()){};
    }

    public static Neow3jExpress build(Neow3jService neow3jService, Neow3jConfig config) {
        return new Neow3jExpress(neow3jService, config);
    }

    @Override
    public Request<?, NeoExpressGetPopulatedBlocks> expressGetPopulatedBlocks() {
        return new Request("expressgetpopulatedblocks", Collections.emptyList(), this.neow3jService, NeoExpressGetPopulatedBlocks.class);
    }

    @Override
    public Request<?, NeoExpressGetNep17Contracts> expressGetNep17Contracts() {
        return new Request("expressgetnep17contracts", Collections.emptyList(), this.neow3jService, NeoExpressGetNep17Contracts.class);
    }

    @Override
    public Request<?, NeoExpressGetContractStorage> expressGetContractStorage(Hash160 contractHash) {
        return new Request<Hash160, NeoExpressGetContractStorage>("expressgetcontractstorage", Arrays.asList(contractHash), this.neow3jService, NeoExpressGetContractStorage.class);
    }

    @Override
    public Request<?, NeoExpressListContracts> expressListContracts() {
        return new Request("expresslistcontracts", Collections.emptyList(), this.neow3jService, NeoExpressListContracts.class);
    }

    @Override
    public Request<?, NeoExpressCreateCheckpoint> expressCreateCheckpoint(String filename) {
        return new Request<String, NeoExpressCreateCheckpoint>("expresscreatecheckpoint", Arrays.asList(filename), this.neow3jService, NeoExpressCreateCheckpoint.class);
    }

    @Override
    public Request<?, NeoExpressListOracleRequests> expressListOracleRequests() {
        return new Request("expresslistoraclerequests", Collections.emptyList(), this.neow3jService, NeoExpressListOracleRequests.class);
    }

    @Override
    public Request<?, NeoExpressCreateOracleResponseTx> expressCreateOracleResponseTx(OracleResponse response) {
        return new Request<OracleResponse, NeoExpressCreateOracleResponseTx>("expresscreateoracleresponsetx", Arrays.asList(response), this.neow3jService, NeoExpressCreateOracleResponseTx.class);
    }

    @Override
    public Request<?, NeoExpressShutdown> expressShutdown() {
        return new Request("expressshutdown", Collections.emptyList(), this.neow3jService, NeoExpressShutdown.class);
    }
}

