/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import io.neow3j.crypto.Base64;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.Neow3jConfig;
import io.neow3j.protocol.Neow3jService;
import io.neow3j.protocol.core.Request;
import io.neow3j.protocol.core.response.NeoBlockCount;
import io.neow3j.protocol.core.response.NeoBlockHash;
import io.neow3j.protocol.core.response.NeoBlockHeaderCount;
import io.neow3j.protocol.core.response.NeoCalculateNetworkFee;
import io.neow3j.protocol.core.response.NeoCloseWallet;
import io.neow3j.protocol.core.response.NeoConnectionCount;
import io.neow3j.protocol.core.response.NeoDumpPrivKey;
import io.neow3j.protocol.core.response.NeoGetApplicationLog;
import io.neow3j.protocol.core.response.NeoGetBlock;
import io.neow3j.protocol.core.response.NeoGetCommittee;
import io.neow3j.protocol.core.response.NeoGetContractState;
import io.neow3j.protocol.core.response.NeoGetMemPool;
import io.neow3j.protocol.core.response.NeoGetNativeContracts;
import io.neow3j.protocol.core.response.NeoGetNep17Balances;
import io.neow3j.protocol.core.response.NeoGetNep17Transfers;
import io.neow3j.protocol.core.response.NeoGetNewAddress;
import io.neow3j.protocol.core.response.NeoGetNextBlockValidators;
import io.neow3j.protocol.core.response.NeoGetPeers;
import io.neow3j.protocol.core.response.NeoGetProof;
import io.neow3j.protocol.core.response.NeoGetRawBlock;
import io.neow3j.protocol.core.response.NeoGetRawMemPool;
import io.neow3j.protocol.core.response.NeoGetRawTransaction;
import io.neow3j.protocol.core.response.NeoGetStateHeight;
import io.neow3j.protocol.core.response.NeoGetStateRoot;
import io.neow3j.protocol.core.response.NeoGetStorage;
import io.neow3j.protocol.core.response.NeoGetTransaction;
import io.neow3j.protocol.core.response.NeoGetTransactionHeight;
import io.neow3j.protocol.core.response.NeoGetUnclaimedGas;
import io.neow3j.protocol.core.response.NeoGetVersion;
import io.neow3j.protocol.core.response.NeoGetWalletBalance;
import io.neow3j.protocol.core.response.NeoGetWalletUnclaimedGas;
import io.neow3j.protocol.core.response.NeoImportPrivKey;
import io.neow3j.protocol.core.response.NeoInvokeContractVerify;
import io.neow3j.protocol.core.response.NeoInvokeFunction;
import io.neow3j.protocol.core.response.NeoInvokeScript;
import io.neow3j.protocol.core.response.NeoListAddress;
import io.neow3j.protocol.core.response.NeoListPlugins;
import io.neow3j.protocol.core.response.NeoOpenWallet;
import io.neow3j.protocol.core.response.NeoSendFrom;
import io.neow3j.protocol.core.response.NeoSendMany;
import io.neow3j.protocol.core.response.NeoSendRawTransaction;
import io.neow3j.protocol.core.response.NeoSendToAddress;
import io.neow3j.protocol.core.response.NeoSubmitBlock;
import io.neow3j.protocol.core.response.NeoValidateAddress;
import io.neow3j.protocol.core.response.NeoVerifyProof;
import io.neow3j.protocol.core.response.TransactionSendToken;
import io.neow3j.protocol.core.response.TransactionSigner;
import io.neow3j.protocol.rx.JsonRpc2_0Rx;
import io.neow3j.transaction.Signer;
import io.neow3j.types.ContractParameter;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import io.reactivex.Observable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonRpc2_0Neow3j
extends Neow3j {
    protected final Neow3jService neow3jService;
    private final JsonRpc2_0Rx neow3jRx;

    public JsonRpc2_0Neow3j(Neow3jService neow3jService, Neow3jConfig config) {
        super(config);
        this.neow3jService = neow3jService;
        this.neow3jRx = new JsonRpc2_0Rx(this, this.getScheduledExecutorService());
    }

    @Override
    public Request<?, NeoBlockHash> getBestBlockHash() {
        return new Request("getbestblockhash", Collections.emptyList(), this.neow3jService, NeoBlockHash.class);
    }

    @Override
    public Request<?, NeoBlockHash> getBlockHash(BigInteger blockIndex) {
        return new Request<BigInteger, NeoBlockHash>("getblockhash", Collections.singletonList(blockIndex), this.neow3jService, NeoBlockHash.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlock(Hash256 blockHash, boolean returnFullTransactionObjects) {
        if (returnFullTransactionObjects) {
            return new Request<Comparable, NeoGetBlock>("getblock", Arrays.asList(blockHash, 1), this.neow3jService, NeoGetBlock.class);
        }
        return this.getBlockHeader(blockHash);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlock(Hash256 blockHash) {
        return new Request<Comparable, NeoGetRawBlock>("getblock", Arrays.asList(blockHash, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlock(BigInteger blockIndex, boolean returnFullTransactionObjects) {
        if (returnFullTransactionObjects) {
            return new Request<Number, NeoGetBlock>("getblock", Arrays.asList(blockIndex, 1), this.neow3jService, NeoGetBlock.class);
        }
        return this.getBlockHeader(blockIndex);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlock(BigInteger blockIndex) {
        return new Request<Number, NeoGetRawBlock>("getblock", Arrays.asList(blockIndex, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoBlockHeaderCount> getBlockHeaderCount() {
        return new Request("getblockheadercount", Collections.emptyList(), this.neow3jService, NeoBlockHeaderCount.class);
    }

    @Override
    public Request<?, NeoBlockCount> getBlockCount() {
        return new Request("getblockcount", Collections.emptyList(), this.neow3jService, NeoBlockCount.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlockHeader(Hash256 blockHash) {
        return new Request<Comparable, NeoGetBlock>("getblockheader", Arrays.asList(blockHash, 1), this.neow3jService, NeoGetBlock.class);
    }

    @Override
    public Request<?, NeoGetBlock> getBlockHeader(BigInteger blockIndex) {
        return new Request<Number, NeoGetBlock>("getblockheader", Arrays.asList(blockIndex, 1), this.neow3jService, NeoGetBlock.class);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlockHeader(Hash256 blockHash) {
        return new Request<Comparable, NeoGetRawBlock>("getblockheader", Arrays.asList(blockHash, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetRawBlock> getRawBlockHeader(BigInteger blockIndex) {
        return new Request<Number, NeoGetRawBlock>("getblockheader", Arrays.asList(blockIndex, 0), this.neow3jService, NeoGetRawBlock.class);
    }

    @Override
    public Request<?, NeoGetNativeContracts> getNativeContracts() {
        return new Request("getnativecontracts", Collections.emptyList(), this.neow3jService, NeoGetNativeContracts.class);
    }

    @Override
    public Request<?, NeoGetContractState> getContractState(Hash160 contractHash) {
        return new Request<Hash160, NeoGetContractState>("getcontractstate", Collections.singletonList(contractHash), this.neow3jService, NeoGetContractState.class);
    }

    @Override
    public Request<?, NeoGetContractState> getNativeContractState(String nativeContractName) {
        return new Request<String, NeoGetContractState>("getcontractstate", Collections.singletonList(nativeContractName), this.neow3jService, NeoGetContractState.class);
    }

    @Override
    public Request<?, NeoGetMemPool> getMemPool() {
        return new Request<Integer, NeoGetMemPool>("getrawmempool", Collections.singletonList(1), this.neow3jService, NeoGetMemPool.class);
    }

    @Override
    public Request<?, NeoGetRawMemPool> getRawMemPool() {
        return new Request("getrawmempool", Collections.emptyList(), this.neow3jService, NeoGetRawMemPool.class);
    }

    @Override
    public Request<?, NeoGetTransaction> getTransaction(Hash256 txHash) {
        return new Request<Comparable, NeoGetTransaction>("getrawtransaction", Arrays.asList(txHash, 1), this.neow3jService, NeoGetTransaction.class);
    }

    @Override
    public Request<?, NeoGetRawTransaction> getRawTransaction(Hash256 txHash) {
        return new Request<Comparable, NeoGetRawTransaction>("getrawtransaction", Arrays.asList(txHash, 0), this.neow3jService, NeoGetRawTransaction.class);
    }

    @Override
    public Request<?, NeoGetStorage> getStorage(Hash160 contractHash, String keyHexString) {
        return new Request<Comparable, NeoGetStorage>("getstorage", Arrays.asList(contractHash, Base64.encode(keyHexString)), this.neow3jService, NeoGetStorage.class);
    }

    @Override
    public Request<?, NeoGetTransactionHeight> getTransactionHeight(Hash256 txHash) {
        return new Request<Hash256, NeoGetTransactionHeight>("gettransactionheight", Collections.singletonList(txHash), this.neow3jService, NeoGetTransactionHeight.class);
    }

    @Override
    public Request<?, NeoGetNextBlockValidators> getNextBlockValidators() {
        return new Request("getnextblockvalidators", Collections.emptyList(), this.neow3jService, NeoGetNextBlockValidators.class);
    }

    @Override
    public Request<?, NeoGetCommittee> getCommittee() {
        return new Request("getcommittee", Collections.emptyList(), this.neow3jService, NeoGetCommittee.class);
    }

    @Override
    public Request<?, NeoConnectionCount> getConnectionCount() {
        return new Request("getconnectioncount", Collections.emptyList(), this.neow3jService, NeoConnectionCount.class);
    }

    @Override
    public Request<?, NeoGetPeers> getPeers() {
        return new Request("getpeers", Collections.emptyList(), this.neow3jService, NeoGetPeers.class);
    }

    @Override
    public Request<?, NeoGetVersion> getVersion() {
        return new Request("getversion", Collections.emptyList(), this.neow3jService, NeoGetVersion.class);
    }

    @Override
    public Request<?, NeoSendRawTransaction> sendRawTransaction(String rawTransactionHex) {
        return new Request<String, NeoSendRawTransaction>("sendrawtransaction", Collections.singletonList(Base64.encode(rawTransactionHex)), this.neow3jService, NeoSendRawTransaction.class);
    }

    @Override
    public Request<?, NeoSubmitBlock> submitBlock(String serializedBlockAsHex) {
        return new Request<String, NeoSubmitBlock>("submitblock", Collections.singletonList(serializedBlockAsHex), this.neow3jService, NeoSubmitBlock.class);
    }

    @Override
    public Request<?, NeoInvokeFunction> invokeFunction(Hash160 contractHash, String functionName, Signer ... signers) {
        return this.invokeFunction(contractHash, functionName, (List<ContractParameter>)null, signers);
    }

    @Override
    public Request<?, NeoInvokeFunction> invokeFunction(Hash160 contractHash, String functionName, List<ContractParameter> contractParams, Signer ... signers) {
        List txSigners;
        if (contractParams == null) {
            contractParams = new ArrayList<ContractParameter>();
        }
        List<Object> params = (txSigners = Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList())).size() > 0 ? Arrays.asList(contractHash, functionName, contractParams, txSigners) : Arrays.asList(contractHash, functionName, contractParams);
        return new Request("invokefunction", params.stream().filter(Objects::nonNull).collect(Collectors.toList()), this.neow3jService, NeoInvokeFunction.class);
    }

    @Override
    public Request<?, NeoInvokeScript> invokeScript(String scriptHex, Signer ... signers) {
        List<Object> params = signers.length > 0 ? Arrays.asList(scriptHex, Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList())) : Collections.singletonList(scriptHex);
        return new Request<String, NeoInvokeScript>("invokescript", params, this.neow3jService, NeoInvokeScript.class);
    }

    @Override
    public Request<?, NeoInvokeContractVerify> invokeContractVerify(Hash160 contractHash, List<ContractParameter> methodParams, Signer ... signers) {
        if (methodParams == null) {
            methodParams = new ArrayList<ContractParameter>();
        }
        List txSigners = Arrays.stream(signers).map(TransactionSigner::new).collect(Collectors.toList());
        List<Object> params = Arrays.asList(contractHash, methodParams, txSigners);
        return new Request("invokecontractverify", params.stream().filter(Objects::nonNull).collect(Collectors.toList()), this.neow3jService, NeoInvokeContractVerify.class);
    }

    @Override
    public Request<?, NeoGetUnclaimedGas> getUnclaimedGas(Hash160 scriptHash) {
        return new Request<String, NeoGetUnclaimedGas>("getunclaimedgas", Collections.singletonList(scriptHash.toAddress()), this.neow3jService, NeoGetUnclaimedGas.class);
    }

    @Override
    public Request<?, NeoListPlugins> listPlugins() {
        return new Request("listplugins", Collections.emptyList(), this.neow3jService, NeoListPlugins.class);
    }

    @Override
    public Request<?, NeoValidateAddress> validateAddress(String address) {
        return new Request<String, NeoValidateAddress>("validateaddress", Collections.singletonList(address), this.neow3jService, NeoValidateAddress.class);
    }

    @Override
    public Request<?, NeoCloseWallet> closeWallet() {
        return new Request("closewallet", Collections.emptyList(), this.neow3jService, NeoCloseWallet.class);
    }

    @Override
    public Request<?, NeoDumpPrivKey> dumpPrivKey(Hash160 scriptHash) {
        return new Request<String, NeoDumpPrivKey>("dumpprivkey", Collections.singletonList(scriptHash.toAddress()), this.neow3jService, NeoDumpPrivKey.class);
    }

    @Override
    public Request<?, NeoGetWalletBalance> getWalletBalance(Hash160 tokenHash) {
        return new Request<Hash160, NeoGetWalletBalance>("getwalletbalance", Collections.singletonList(tokenHash), this.neow3jService, NeoGetWalletBalance.class);
    }

    @Override
    public Request<?, NeoGetNewAddress> getNewAddress() {
        return new Request("getnewaddress", Collections.emptyList(), this.neow3jService, NeoGetNewAddress.class);
    }

    @Override
    public Request<?, NeoGetWalletUnclaimedGas> getWalletUnclaimedGas() {
        return new Request("getwalletunclaimedgas", Collections.emptyList(), this.neow3jService, NeoGetWalletUnclaimedGas.class);
    }

    @Override
    public Request<?, NeoImportPrivKey> importPrivKey(String privateKeyInWIF) {
        return new Request<String, NeoImportPrivKey>("importprivkey", Collections.singletonList(privateKeyInWIF), this.neow3jService, NeoImportPrivKey.class);
    }

    @Override
    public Request<?, NeoCalculateNetworkFee> calculateNetworkFee(String txHex) {
        return new Request<String, NeoCalculateNetworkFee>("calculatenetworkfee", Collections.singletonList(Base64.encode(txHex)), this.neow3jService, NeoCalculateNetworkFee.class);
    }

    @Override
    public Request<?, NeoListAddress> listAddress() {
        return new Request("listaddress", Collections.emptyList(), this.neow3jService, NeoListAddress.class);
    }

    @Override
    public Request<?, NeoOpenWallet> openWallet(String walletPath, String password) {
        return new Request<String, NeoOpenWallet>("openwallet", Arrays.asList(walletPath, password), this.neow3jService, NeoOpenWallet.class);
    }

    @Override
    public Request<?, NeoSendFrom> sendFrom(Hash160 tokenHash, Hash160 from, Hash160 to, BigInteger amount) {
        return new Request<Comparable, NeoSendFrom>("sendfrom", Arrays.asList(tokenHash, from.toAddress(), to.toAddress(), amount), this.neow3jService, NeoSendFrom.class);
    }

    @Override
    public Request<?, NeoSendFrom> sendFrom(Hash160 from, TransactionSendToken txSendToken) {
        return this.sendFrom(txSendToken.getToken(), from, Hash160.fromAddress(txSendToken.getAddress()), txSendToken.getValue());
    }

    @Override
    public Request<?, NeoSendMany> sendMany(List<TransactionSendToken> txSendTokens) {
        return new Request("sendmany", Collections.singletonList(txSendTokens.stream().filter(Objects::nonNull).collect(Collectors.toList())), this.neow3jService, NeoSendMany.class);
    }

    @Override
    public Request<?, NeoSendMany> sendMany(Hash160 from, List<TransactionSendToken> txSendTokens) {
        return new Request<Object, NeoSendMany>("sendmany", Arrays.asList(from.toAddress(), txSendTokens.stream().filter(Objects::nonNull).collect(Collectors.toList())), this.neow3jService, NeoSendMany.class);
    }

    @Override
    public Request<?, NeoSendToAddress> sendToAddress(Hash160 tokenHash, Hash160 to, BigInteger amount) {
        return new Request("sendtoaddress", Stream.of(tokenHash, to.toAddress(), amount).filter(Objects::nonNull).collect(Collectors.toList()), this.neow3jService, NeoSendToAddress.class);
    }

    @Override
    public Request<?, NeoSendToAddress> sendToAddress(TransactionSendToken txSendToken) {
        return this.sendToAddress(txSendToken.getToken(), Hash160.fromAddress(txSendToken.getAddress()), txSendToken.getValue());
    }

    @Override
    public Request<?, NeoGetApplicationLog> getApplicationLog(Hash256 txHash) {
        return new Request<Hash256, NeoGetApplicationLog>("getapplicationlog", Collections.singletonList(txHash), this.neow3jService, NeoGetApplicationLog.class);
    }

    @Override
    public Request<?, NeoGetNep17Balances> getNep17Balances(Hash160 scriptHash) {
        return new Request<String, NeoGetNep17Balances>("getnep17balances", Collections.singletonList(scriptHash.toAddress()), this.neow3jService, NeoGetNep17Balances.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(Hash160 scriptHash) {
        return new Request<String, NeoGetNep17Transfers>("getnep17transfers", Collections.singletonList(scriptHash.toAddress()), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(Hash160 scriptHash, Date from) {
        return new Request<Serializable, NeoGetNep17Transfers>("getnep17transfers", Arrays.asList(scriptHash.toAddress(), from.getTime()), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Request<?, NeoGetNep17Transfers> getNep17Transfers(Hash160 scriptHash, Date from, Date until) {
        return new Request<Serializable, NeoGetNep17Transfers>("getnep17transfers", Arrays.asList(scriptHash.toAddress(), from.getTime(), until.getTime()), this.neow3jService, NeoGetNep17Transfers.class);
    }

    @Override
    public Request<?, NeoGetStateRoot> getStateRoot(BigInteger blockIndex) {
        return new Request<BigInteger, NeoGetStateRoot>("getstateroot", Collections.singletonList(blockIndex), this.neow3jService, NeoGetStateRoot.class);
    }

    @Override
    public Request<?, NeoGetProof> getProof(Hash256 rootHash, Hash160 contractHash, String storageKeyHex) {
        return new Request<Comparable, NeoGetProof>("getproof", Arrays.asList(rootHash, contractHash, Base64.encode(storageKeyHex)), this.neow3jService, NeoGetProof.class);
    }

    @Override
    public Request<?, NeoVerifyProof> verifyProof(Hash256 rootHash, String proofDataHex) {
        return new Request<Comparable, NeoVerifyProof>("verifyproof", Arrays.asList(rootHash, Base64.encode(proofDataHex)), this.neow3jService, NeoVerifyProof.class);
    }

    @Override
    public Request<?, NeoGetStateHeight> getStateHeight() {
        return new Request("getstateheight", Collections.emptyList(), this.neow3jService, NeoGetStateHeight.class);
    }

    @Override
    public Observable<NeoGetBlock> blockObservable(boolean fullTransactionObjects) {
        return this.neow3jRx.blockObservable(fullTransactionObjects, this.getPollingInterval());
    }

    @Override
    public Observable<NeoGetBlock> replayBlocksObservable(BigInteger startBlock, BigInteger endBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Observable<NeoGetBlock> replayBlocksObservable(BigInteger startBlock, BigInteger endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.neow3jRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BigInteger startBlock, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        return this.neow3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, onCompleteObservable);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BigInteger startBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects);
    }

    @Override
    public Observable<NeoGetBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(BigInteger startBlock, boolean fullTransactionObjects) {
        return this.neow3jRx.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, fullTransactionObjects, this.getPollingInterval());
    }

    @Override
    public Observable<NeoGetBlock> subscribeToNewBlocksObservable(boolean fullTransactionObjects) throws IOException {
        return this.neow3jRx.subscribeToNewBlocksObservable(fullTransactionObjects, this.getPollingInterval());
    }

    @Override
    public void shutdown() {
        this.getScheduledExecutorService().shutdown();
        try {
            this.neow3jService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close neow3j service", e);
        }
    }
}

