/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.neow3j.protocol.deserializer.KeepAsJsonDeserialzier;
import io.neow3j.protocol.exceptions.ErrorResponseException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Response<T> {
    private long id;
    private String jsonrpc;
    private T result;
    private Error error;
    private String rawResponse;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public void throwOnError() throws ErrorResponseException {
        if (this.hasError()) {
            throw new ErrorResponseException(this.error);
        }
    }

    public static class Error {
        private int code;
        private String message;
        @JsonDeserialize(using=KeepAsJsonDeserialzier.class)
        private String data;

        public Error() {
        }

        public Error(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error error = (Error)o;
            if (this.getCode() != error.getCode()) {
                return false;
            }
            if (this.getMessage() != null ? !this.getMessage().equals(error.getMessage()) : error.getMessage() != null) {
                return false;
            }
            return this.getData() != null ? this.getData().equals(error.getData()) : error.getData() == null;
        }

        public int hashCode() {
            int result = this.getCode();
            result = 31 * result + (this.getMessage() != null ? this.getMessage().hashCode() : 0);
            result = 31 * result + (this.getData() != null ? this.getData().hashCode() : 0);
            return result;
        }
    }
}

