/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.polling;

import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.polling.Callback;
import io.reactivex.Observable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockPolling {
    private static final Logger LOG = LoggerFactory.getLogger(BlockPolling.class);
    private BigInteger currentBlock;
    private final Neow3j neow3j;
    private final Callback<BigInteger> callback;
    private ScheduledFuture<?> schedule;

    public BlockPolling(Neow3j neow3j, Callback<BigInteger> callback) {
        this.neow3j = neow3j;
        this.callback = callback;
    }

    public BigInteger getCurrentBlock() {
        return this.currentBlock;
    }

    public synchronized void nextBlock() {
        this.currentBlock = this.currentBlock.add(BigInteger.ONE);
    }

    private BigInteger getLatestBlockIndex() throws IOException {
        return this.neow3j.getBlockCount().send().getBlockCount();
    }

    public void run(ScheduledExecutorService scheduledExecutorService, long pollingInterval) {
        this.schedule = scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                BigInteger latestBlockNumber = this.getLatestBlockIndex().subtract(BigInteger.ONE);
                if (this.currentBlock == null) {
                    this.currentBlock = latestBlockNumber;
                }
                if (latestBlockNumber.compareTo(this.getCurrentBlock()) == 1) {
                    IntStream.rangeClosed(this.getCurrentBlock().add(BigInteger.ONE).intValue(), latestBlockNumber.intValue()).forEachOrdered(blockIndex -> {
                        this.callback.onEvent(BigInteger.valueOf(blockIndex));
                        this.nextBlock();
                    });
                }
            }
            catch (Throwable e) {
                LOG.error("Error on polling: {}", e);
                Observable.error((Throwable)e);
            }
        }, 0L, pollingInterval, TimeUnit.MILLISECONDS);
    }

    public void cancel() {
        this.schedule.cancel(false);
    }
}

