/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.NeoVMStateType;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InvocationResult {
    @JsonProperty(value="script")
    private String script;
    @JsonProperty(value="state")
    private NeoVMStateType state;
    @JsonProperty(value="gasconsumed")
    private String gasConsumed;
    @JsonProperty(value="exception")
    private String exception;
    @JsonProperty(value="stack")
    private List<StackItem> stack;
    @JsonProperty(value="tx")
    private String tx;

    public InvocationResult() {
    }

    public InvocationResult(String script, NeoVMStateType state, String gasConsumed, String exception, List<StackItem> stack, String tx) {
        this.script = script;
        this.state = state;
        this.gasConsumed = gasConsumed;
        this.exception = exception;
        this.stack = stack;
        this.tx = tx;
    }

    public String getScript() {
        return this.script;
    }

    public NeoVMStateType getState() {
        return this.state;
    }

    public boolean hasStateFault() {
        return this.state == NeoVMStateType.FAULT;
    }

    public String getGasConsumed() {
        return this.gasConsumed;
    }

    public String getException() {
        return this.exception;
    }

    public List<StackItem> getStack() {
        return this.stack;
    }

    public String getTx() {
        return this.tx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationResult)) {
            return false;
        }
        InvocationResult that = (InvocationResult)o;
        return Objects.equals(this.getScript(), that.getScript()) && Objects.equals((Object)this.getState(), (Object)that.getState()) && Objects.equals(this.getGasConsumed(), that.getGasConsumed()) && Objects.equals(this.getException(), that.getException()) && Objects.equals(this.getStack(), that.getStack()) && Objects.equals(this.getTx(), that.getTx());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getScript(), this.getState(), this.getGasConsumed(), this.getException(), this.getStack(), this.getTx()});
    }

    public String toString() {
        return "InvocationResult{script='" + this.script + '\'' + ", state=" + (Object)((Object)this.state) + ", gasconsumed=" + this.gasConsumed + ", exception='" + this.exception + '\'' + ", stack=" + this.stack + ", tx='" + this.tx + '\'' + '}';
    }
}

