/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.StackItemType;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BooleanStackItem
extends StackItem {
    @JsonProperty(value="value")
    private Boolean value;

    public BooleanStackItem() {
        super(StackItemType.BOOLEAN);
    }

    public BooleanStackItem(Boolean value) {
        super(StackItemType.BOOLEAN);
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        this.nullCheck();
        return this.value;
    }

    @Override
    public BigInteger getInteger() {
        this.nullCheck();
        return this.value != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public String getString() {
        this.nullCheck();
        return this.value.toString();
    }

    @Override
    protected String valueToString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanStackItem)) {
            return false;
        }
        BooleanStackItem other = (BooleanStackItem)o;
        return this.getType() == other.getType() && this.getValue() == other.getValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }
}

