/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.protocol.exceptions.StackItemCastException;
import io.neow3j.types.Hash160;
import io.neow3j.types.StackItemType;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.BigIntegers;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

abstract class ByteArrayStackItem
extends StackItem {
    @JsonProperty(value="value")
    private byte[] value;

    protected ByteArrayStackItem(StackItemType type) {
        super(type);
    }

    protected ByteArrayStackItem(byte[] value, StackItemType type) {
        super(type);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public String getAddress() {
        this.nullCheck();
        try {
            return new Hash160(ArrayUtils.reverseArray(this.value)).toAddress();
        }
        catch (IllegalArgumentException e) {
            throw new StackItemCastException(e);
        }
    }

    @Override
    public String getString() {
        this.nullCheck();
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public String getHexString() {
        this.nullCheck();
        return Numeric.toHexStringNoPrefix(this.value);
    }

    @Override
    public byte[] getByteArray() {
        this.nullCheck();
        return this.value;
    }

    @Override
    public BigInteger getInteger() {
        this.nullCheck();
        try {
            return BigIntegers.fromLittleEndianByteArray(this.value);
        }
        catch (NumberFormatException e) {
            throw new StackItemCastException(e);
        }
    }

    @Override
    public boolean getBoolean() {
        this.nullCheck();
        return this.getInteger().compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    protected String valueToString() {
        return Numeric.toHexStringNoPrefix(this.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, Arrays.hashCode(this.getValue())});
    }
}

