/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.protocol.exceptions.StackItemCastException;
import io.neow3j.types.StackItemType;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InteropInterfaceStackItem
extends StackItem {
    @JsonProperty(value="iterator")
    private List<StackItem> iterator;
    @JsonProperty(value="truncated")
    private Boolean truncated;

    public InteropInterfaceStackItem() {
        super(StackItemType.INTEROP_INTERFACE);
    }

    @Override
    public List<StackItem> getValue() {
        return this.iterator;
    }

    @Override
    protected String valueToString() {
        return this.iterator.stream().map(StackItem::toString).reduce("", (a, b) -> a + ", " + b).substring(2);
    }

    public InteropInterfaceStackItem(List<StackItem> iterator, Boolean truncated) {
        super(StackItemType.INTEROP_INTERFACE);
        this.iterator = iterator;
        this.truncated = truncated;
    }

    @Override
    public List<StackItem> getIterator() {
        if (this.iterator == null) {
            throw new StackItemCastException(String.format("Cannot cast stack item %s to an iterator.", this.toString()));
        }
        return this.iterator;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InteropInterfaceStackItem)) {
            return false;
        }
        InteropInterfaceStackItem other = (InteropInterfaceStackItem)o;
        return this.getType() == other.getType() && this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }
}

