/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core.stackitem;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.neow3j.protocol.core.stackitem.StackItem;
import io.neow3j.types.StackItemType;
import java.math.BigInteger;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PointerStackItem
extends StackItem {
    @JsonProperty(value="value")
    private BigInteger value;

    public PointerStackItem() {
        super(StackItemType.POINTER);
    }

    public PointerStackItem(BigInteger value) {
        super(StackItemType.POINTER);
        this.value = value;
    }

    @Override
    protected String valueToString() {
        return this.value.toString();
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public BigInteger getInteger() {
        this.nullCheck();
        return this.value;
    }

    @Override
    public BigInteger getPointer() {
        this.nullCheck();
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointerStackItem)) {
            return false;
        }
        PointerStackItem other = (PointerStackItem)o;
        return this.getType() == other.getType() && this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }
}

