/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.neow3j.protocol.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class RawResponseDeserializer
extends StdDeserializer<Response>
implements ResolvableDeserializer {
    private final JsonDeserializer<?> defaultDeserializer;

    public RawResponseDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(Response.class);
        this.defaultDeserializer = defaultDeserializer;
    }

    public Response deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Response deserializedResponse = (Response)this.defaultDeserializer.deserialize(jp, ctxt);
        deserializedResponse.setRawResponse(this.getRawResponse(jp));
        return deserializedResponse;
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }

    private String getRawResponse(JsonParser jp) throws IOException {
        InputStream inputSource = (InputStream)jp.getInputSource();
        if (inputSource == null) {
            return "";
        }
        inputSource.reset();
        return this.streamToString(inputSource);
    }

    private String streamToString(InputStream input) throws IOException {
        return new Scanner(input, StandardCharsets.UTF_8.name()).useDelimiter("\\Z").next();
    }
}

