/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.http;

import io.neow3j.protocol.Service;
import io.neow3j.protocol.exceptions.ClientConnectionException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
extends Service {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String DEFAULT_URL = "http://localhost:10333/";
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    private final String url;
    private final boolean includeRawResponses;
    private OkHttpClient httpClient;
    private HashMap<String, String> headers = new HashMap();

    public HttpService(String url, OkHttpClient httpClient, ExecutorService executorService, boolean includeRawResponses) {
        super(executorService, includeRawResponses);
        this.url = url;
        this.httpClient = httpClient;
        this.includeRawResponses = includeRawResponses;
    }

    public HttpService(String url, OkHttpClient httpClient, boolean includeRawResponses) {
        this(url, httpClient, null, includeRawResponses);
    }

    public HttpService(OkHttpClient httpClient, ExecutorService executorService, boolean includeRawResponses) {
        this(DEFAULT_URL, httpClient, executorService, includeRawResponses);
    }

    public HttpService(OkHttpClient httpClient, boolean includeRawResponses) {
        this(DEFAULT_URL, httpClient, includeRawResponses);
    }

    public HttpService(String url, OkHttpClient httpClient, ExecutorService executorService) {
        this(url, httpClient, executorService, false);
    }

    public HttpService(String url, OkHttpClient httpClient) {
        this(url, httpClient, false);
    }

    public HttpService(String url, ExecutorService executorService) {
        this(url, HttpService.createOkHttpClient(), executorService);
    }

    public HttpService(String url) {
        this(url, HttpService.createOkHttpClient());
    }

    public HttpService(String url, ExecutorService executorService, boolean includeRawResponses) {
        this(url, HttpService.createOkHttpClient(), executorService, includeRawResponses);
    }

    public HttpService(String url, boolean includeRawResponses) {
        this(url, HttpService.createOkHttpClient(), includeRawResponses);
    }

    public HttpService(OkHttpClient httpClient, ExecutorService executorService) {
        this(DEFAULT_URL, httpClient, executorService);
    }

    public HttpService(OkHttpClient httpClient) {
        this(DEFAULT_URL, httpClient);
    }

    public HttpService(ExecutorService executorService, boolean includeRawResponses) {
        this(DEFAULT_URL, executorService, includeRawResponses);
    }

    public HttpService(boolean includeRawResponses) {
        this(DEFAULT_URL, includeRawResponses);
    }

    public HttpService() {
        this(DEFAULT_URL);
    }

    private static OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpService.configureLogging(builder);
        return builder.build();
    }

    private static void configureLogging(OkHttpClient.Builder builder) {
        if (log.isDebugEnabled()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)log).debug(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
    }

    @Override
    protected InputStream performIO(String request) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)request);
        Headers headers = this.buildHeaders();
        Request httpRequest = new Request.Builder().url(this.url).headers(headers).post(requestBody).build();
        Response response = this.httpClient.newCall(httpRequest).execute();
        ResponseBody responseBody = response.body();
        if (response.isSuccessful()) {
            if (responseBody != null) {
                return this.buildInputStream(responseBody);
            }
            return null;
        }
        int code = response.code();
        String text = responseBody == null ? "N/A" : responseBody.string();
        throw new ClientConnectionException("Invalid response received: " + code + "; " + text);
    }

    private InputStream buildInputStream(ResponseBody responseBody) throws IOException {
        InputStream inputStream = responseBody.byteStream();
        if (this.includeRawResponses) {
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            long size = buffer.size();
            if (size > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Non-integer input buffer size specified: " + size);
            }
            int bufferSize = (int)size;
            BufferedInputStream bufferedinputStream = new BufferedInputStream(inputStream, bufferSize);
            bufferedinputStream.mark(inputStream.available());
            return bufferedinputStream;
        }
        return inputStream;
    }

    private Headers buildHeaders() {
        return Headers.of(this.headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headersToAdd) {
        this.headers.putAll(headersToAdd);
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void close() {
    }
}

