/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.rx;

import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.polling.BlockPolling;
import io.neow3j.protocol.core.response.NeoGetBlock;
import io.neow3j.protocol.core.response.Transaction;
import io.neow3j.utils.Observables;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposables;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class JsonRpc2_0Rx {
    private final Neow3j neow3j;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(Neow3j neow3j, ScheduledExecutorService scheduledExecutorService) {
        this.neow3j = neow3j;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from((Executor)scheduledExecutorService);
    }

    public Observable<BigInteger> neoBlockObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            BlockPolling blockPolling = new BlockPolling(this.neow3j, arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
            blockPolling.run(this.scheduledExecutorService, pollingInterval);
            subscriber.setDisposable(Disposables.fromAction(blockPolling::cancel));
        });
    }

    public Observable<NeoGetBlock> replayBlocksObservable(BigInteger startBlock, BigInteger endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Observable<NeoGetBlock> replayBlocksObservable(BigInteger startBlock, BigInteger endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Observable<NeoGetBlock> replayBlocksObservableSync(BigInteger startBlock, BigInteger endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Observable<NeoGetBlock> replayBlocksObservableSync(BigInteger startBlockNumber, BigInteger endBlockNumber, boolean fullTransactionObjects, boolean ascending) {
        if (ascending) {
            return Observables.range(startBlockNumber, endBlockNumber).flatMap(i -> this.neow3j.getBlock((BigInteger)i, fullTransactionObjects).observable());
        }
        return Observables.range(startBlockNumber, endBlockNumber, false).flatMap(i -> this.neow3j.getBlock((BigInteger)i, fullTransactionObjects).observable());
    }

    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BigInteger startBlock, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        return this.catchUpToLatestBlockObservableSync(startBlock, fullTransactionObjects, onCompleteObservable).subscribeOn(this.scheduler);
    }

    public Observable<NeoGetBlock> catchUpToLatestBlockObservable(BigInteger startBlock, boolean fullTransactionObjects) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, (Observable<NeoGetBlock>)Observable.empty());
    }

    private Observable<NeoGetBlock> catchUpToLatestBlockObservableSync(BigInteger startBlockNumber, boolean fullTransactionObjects, Observable<NeoGetBlock> onCompleteObservable) {
        BigInteger latestBlockNumber;
        try {
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteObservable;
        }
        return Observable.concat(this.replayBlocksObservableSync(startBlockNumber, latestBlockNumber, fullTransactionObjects), (ObservableSource)Observable.defer(() -> this.catchUpToLatestBlockObservableSync(latestBlockNumber.add(BigInteger.ONE), fullTransactionObjects, onCompleteObservable)));
    }

    public Observable<Transaction> catchUpToLatestTransactionObservable(BigInteger startBlock) {
        return this.catchUpToLatestBlockObservable(startBlock, true, (Observable<NeoGetBlock>)Observable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<NeoGetBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(BigInteger startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, this.blockObservable(fullTransactionObjects, pollingInterval));
    }

    public Observable<NeoGetBlock> blockObservable(boolean fullTransactionObjects, long pollingInterval) {
        return this.neoBlockObservable(pollingInterval).flatMap(blockIndex -> this.neow3j.getBlock((BigInteger)blockIndex, fullTransactionObjects).observable());
    }

    public Observable<NeoGetBlock> subscribeToNewBlocksObservable(boolean fullTransactionObjects, long pollingInterval) throws IOException {
        return this.catchUpToLatestAndSubscribeToNewBlocksObservable(this.getLatestBlockNumber(), fullTransactionObjects, pollingInterval);
    }

    private static List<Transaction> toTransactions(NeoGetBlock neoGetBlock) {
        return new ArrayList<Transaction>(neoGetBlock.getBlock().getTransactions());
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.neow3j.getBlockCount().send().getBlockCount().subtract(BigInteger.ONE);
    }
}

