/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.serialization;

import io.neow3j.serialization.NeoSerializable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.math.ec.ECPoint;

public class BinaryWriter
implements AutoCloseable {
    private DataOutputStream writer;
    private byte[] array = new byte[8];
    private ByteBuffer buffer = ByteBuffer.wrap(this.array).order(ByteOrder.LITTLE_ENDIAN);

    public BinaryWriter(OutputStream stream) {
        this.writer = new DataOutputStream(stream);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(byte[] buffer) throws IOException {
        this.writer.write(buffer);
    }

    public void write(byte[] buffer, int index, int length) throws IOException {
        this.writer.write(buffer, index, length);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.writer.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.writer.writeByte(v);
    }

    public void writeDouble(double v) throws IOException {
        this.buffer.putDouble(0, v);
        this.writer.write(this.array, 0, 8);
    }

    public void writeECPoint(ECPoint v) throws IOException {
        this.writer.write(v.getEncoded(true));
    }

    public void writeFixedString(String v, int length) throws IOException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (v.length() > length) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > length) {
            throw new IllegalArgumentException();
        }
        this.writer.write(bytes);
        if (bytes.length < length) {
            this.writer.write(new byte[length - bytes.length]);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.buffer.putFloat(0, v);
        this.writer.write(this.array, 0, 4);
    }

    public void writeInt32(int v) throws IOException {
        this.buffer.putInt(0, v);
        this.writer.write(this.array, 0, 4);
    }

    public void writeInt64(long v) throws IOException {
        this.buffer.putLong(0, v);
        this.writer.write(this.array, 0, 8);
    }

    public void writeUInt32(long v) throws IOException {
        if (v < 0L || v >= (long)Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException("Value of 32-bit unsigned integer was not in interval [0, 2^32).");
        }
        this.buffer.putLong(0, v);
        this.writer.write(this.array, 0, 4);
    }

    public void writeSerializableVariableBytes(NeoSerializable v) throws IOException {
        this.writeVarInt(v.toArray().length);
        v.serialize(this);
    }

    public void writeSerializableVariable(List<? extends NeoSerializable> v) throws IOException {
        this.writeVarInt(v.size());
        this.writeSerializableFixed(v);
    }

    public void writeSerializableVariableBytes(List<? extends NeoSerializable> v) throws IOException {
        int sumLength = 0;
        for (int i = 0; i < v.size(); ++i) {
            sumLength += v.get(i).toArray().length;
        }
        this.writeVarInt(sumLength);
        this.writeSerializableFixed(v);
    }

    public void writeSerializableFixed(NeoSerializable v) throws IOException {
        v.serialize(this);
    }

    public void writeSerializableFixed(List<? extends NeoSerializable> v) throws IOException {
        for (int i = 0; i < v.size(); ++i) {
            v.get(i).serialize(this);
        }
    }

    public void writeUInt16(int v) throws IOException {
        if (v < 0 || v >= (int)Math.pow(2.0, 16.0)) {
            throw new IllegalArgumentException("Value of 16-bit unsigned integer was not in interval [0, 2^16).");
        }
        this.buffer.putInt(0, v);
        this.writer.write(this.array, 0, 2);
    }

    public void writeVarBytes(byte[] v) throws IOException {
        this.writeVarInt(v.length);
        this.writer.write(v);
    }

    public void writeVarInt(long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException();
        }
        if (v < 253L) {
            this.writeByte((byte)v);
        } else if (v <= 65535L) {
            this.writeByte((byte)-3);
            this.writeUInt16((int)v);
        } else if (v <= 0xFFFFFFFFL) {
            this.writeByte((byte)-2);
            this.writeUInt32(v);
        } else {
            this.writeByte((byte)-1);
            this.writeInt64(v);
        }
    }

    public void writeVarString(String value) throws IOException {
        this.writeVarBytes(value.getBytes(StandardCharsets.UTF_8));
    }
}

