/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.transaction.Signer;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.types.Hash160;
import io.neow3j.wallet.Account;

public class AccountSigner
extends Signer {
    private AccountSigner(Hash160 signerHash, WitnessScope scope) {
        super(signerHash, scope);
    }

    public static AccountSigner none(Account account) {
        return AccountSigner.none(account.getScriptHash());
    }

    public static AccountSigner none(Hash160 account) {
        return new AccountSigner(account, WitnessScope.NONE);
    }

    public static AccountSigner calledByEntry(Account account) {
        return AccountSigner.calledByEntry(account.getScriptHash());
    }

    public static AccountSigner calledByEntry(Hash160 account) {
        return new AccountSigner(account, WitnessScope.CALLED_BY_ENTRY);
    }

    public static AccountSigner global(Account account) {
        return AccountSigner.global(account.getScriptHash());
    }

    public static AccountSigner global(Hash160 account) {
        return new AccountSigner(account, WitnessScope.GLOBAL);
    }
}

