/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.protocol.core.response.OracleResponseCode;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.IOUtils;
import io.neow3j.transaction.TransactionAttribute;
import io.neow3j.transaction.TransactionAttributeType;
import io.neow3j.utils.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class OracleResponseAttribute
extends TransactionAttribute {
    public static final int MAX_RESULT_SIZE = 65535;
    public BigInteger id;
    public OracleResponseCode code;
    public byte[] result;

    public OracleResponseAttribute() {
        super(TransactionAttributeType.ORACLE_RESPONSE);
    }

    public BigInteger getId() {
        return this.id;
    }

    public OracleResponseCode getCode() {
        return this.code;
    }

    public byte[] getResult() {
        return this.result;
    }

    @Override
    protected int getSizeWithoutType() {
        return 9 + IOUtils.getVarSize(this.result);
    }

    @Override
    protected void deserializeWithoutType(BinaryReader reader) throws IOException {
        this.id = BigIntegers.fromLittleEndianByteArray(reader.readBytes(8));
        this.code = OracleResponseCode.valueOf(reader.readByte());
        this.result = reader.readVarBytes(65535);
    }

    @Override
    protected void serializeWithoutType(BinaryWriter writer) throws IOException {
        writer.write(BigIntegers.toLittleEndianByteArray(this.id));
        writer.writeByte(this.code.byteValue());
        writer.writeVarBytes(this.result);
    }
}

