/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.neow3j.crypto.Hash;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.ObjectMapperFactory;
import io.neow3j.protocol.core.response.NeoApplicationLog;
import io.neow3j.protocol.core.response.NeoSendRawTransaction;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.IOUtils;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.transaction.Signer;
import io.neow3j.transaction.TransactionAttribute;
import io.neow3j.transaction.Witness;
import io.neow3j.transaction.WitnessScope;
import io.neow3j.transaction.exceptions.TransactionConfigurationException;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import io.reactivex.Observable;
import io.reactivex.functions.Predicate;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Transaction
extends NeoSerializable {
    public static final int HEADER_SIZE = 25;
    protected Neow3j neow3j;
    private byte version;
    private long nonce;
    private long validUntilBlock;
    private List<Signer> signers;
    private long systemFee;
    private long networkFee;
    private List<TransactionAttribute> attributes;
    private byte[] script;
    private List<Witness> witnesses;
    private BigInteger blockCountWhenSent;

    public Transaction() {
        this.signers = new ArrayList<Signer>();
        this.attributes = new ArrayList<TransactionAttribute>();
        this.witnesses = new ArrayList<Witness>();
    }

    public Transaction(Neow3j neow3j, byte version, long nonce, long validUntilBlock, List<Signer> signers, long systemFee, long networkFee, List<TransactionAttribute> attributes, byte[] script, List<Witness> witnesses) {
        this.neow3j = neow3j;
        this.version = version;
        this.nonce = nonce;
        this.validUntilBlock = validUntilBlock;
        this.signers = signers;
        this.systemFee = systemFee;
        this.networkFee = networkFee;
        this.attributes = attributes;
        this.script = script;
        this.witnesses = witnesses;
    }

    public void setNeow3j(Neow3j neow3j) {
        this.neow3j = neow3j;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getNonce() {
        return this.nonce;
    }

    public long getValidUntilBlock() {
        return this.validUntilBlock;
    }

    public List<Signer> getSigners() {
        return this.signers;
    }

    public Hash160 getSender() {
        return this.signers.stream().filter(signer -> signer.getScopes().contains((Object)WitnessScope.NONE)).findFirst().orElse(this.signers.get(0)).getScriptHash();
    }

    public long getSystemFee() {
        return this.systemFee;
    }

    public long getNetworkFee() {
        return this.networkFee;
    }

    public List<TransactionAttribute> getAttributes() {
        return this.attributes;
    }

    public byte[] getScript() {
        return this.script;
    }

    public List<Witness> getWitnesses() {
        return this.witnesses;
    }

    public void addWitness(Witness witness) {
        this.witnesses.add(witness);
    }

    public Hash256 getTxId() {
        return new Hash256(ArrayUtils.reverseArray(Hash.sha256(this.toArrayWithoutWitnesses())));
    }

    public NeoSendRawTransaction send() throws IOException {
        if (this.getSigners().size() != this.getWitnesses().size()) {
            throw new TransactionConfigurationException("The transaction does not have the same number of signers and witnesses. For every signer there has to be one witness, even if that witness is empty.");
        }
        int size = this.getSize();
        if (size > 102400) {
            throw new TransactionConfigurationException(String.format("The transaction exceeds the maximum transaction size. The maximum size is {} bytes. This transaction has size {}", 102400, size));
        }
        String hex = Numeric.toHexStringNoPrefix(this.toArray());
        this.blockCountWhenSent = this.neow3j.getBlockCount().send().getBlockCount();
        return this.neow3j.sendRawTransaction(hex).send();
    }

    public Observable<Long> track() {
        if (this.blockCountWhenSent == null) {
            throw new IllegalStateException("Can't subscribe before transaction has been sent.");
        }
        Predicate pred = neoGetBlock -> neoGetBlock.getBlock().getTransactions() != null && neoGetBlock.getBlock().getTransactions().stream().anyMatch(tx -> tx.getHash().equals(this.getTxId()));
        return this.neow3j.catchUpToLatestAndSubscribeToNewBlocksObservable(this.blockCountWhenSent, true).takeUntil(pred).filter(pred).map(neoGetBlock -> neoGetBlock.getBlock().getIndex());
    }

    public NeoApplicationLog getApplicationLog() {
        if (this.blockCountWhenSent == null) {
            throw new IllegalStateException("Can't get the application log before transaction has been sent.");
        }
        NeoApplicationLog applicationLog = null;
        try {
            applicationLog = this.neow3j.getApplicationLog(this.getTxId()).send().getApplicationLog();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return applicationLog;
    }

    @Override
    public int getSize() {
        return 25 + IOUtils.getVarSize(this.signers) + IOUtils.getVarSize(this.attributes) + IOUtils.getVarSize(this.script) + IOUtils.getVarSize(this.witnesses);
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.version = reader.readByte();
            this.nonce = reader.readUInt32();
            this.systemFee = reader.readInt64();
            this.networkFee = reader.readInt64();
            this.validUntilBlock = reader.readUInt32();
            this.signers = reader.readSerializableList(Signer.class);
            this.readTransactionAttributes(reader);
            this.script = reader.readVarBytes();
            this.witnesses = reader.readSerializableList(Witness.class);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    private void readTransactionAttributes(BinaryReader reader) throws IOException, DeserializationException {
        long nrOfAttributes = reader.readVarInt();
        if (nrOfAttributes + (long)this.signers.size() > 16L) {
            throw new DeserializationException("A transaction can hold at most 16 attributes (including signers). Input data had " + nrOfAttributes + " attributes.");
        }
        int i = 0;
        while ((long)i < nrOfAttributes) {
            this.attributes.add(TransactionAttribute.deserializeAttribute(reader));
            ++i;
        }
    }

    private void serializeWithoutWitnesses(BinaryWriter writer) throws IOException {
        writer.writeByte(this.version);
        writer.writeUInt32(this.nonce);
        writer.writeInt64(this.systemFee);
        writer.writeInt64(this.networkFee);
        writer.writeUInt32(this.validUntilBlock);
        writer.writeSerializableVariable(this.signers);
        writer.writeSerializableVariable(this.attributes);
        writer.writeVarBytes(this.script);
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        this.serializeWithoutWitnesses(writer);
        writer.writeSerializableVariable(this.witnesses);
    }

    /*
     * Exception decompiling
     */
    public byte[] toArrayWithoutWitnesses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getHashData() throws IOException {
        return ArrayUtils.concatenate(this.neow3j.getNetworkMagicNumberBytes(), Hash.sha256(this.toArrayWithoutWitnesses()));
    }

    @Override
    public byte[] toArray() {
        return super.toArray();
    }

    public String toJson() throws JsonProcessingException {
        io.neow3j.protocol.core.response.Transaction dtoTx = new io.neow3j.protocol.core.response.Transaction(this);
        return ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)dtoTx);
    }
}

