/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.transaction.TransactionAttributeType;
import java.io.IOException;
import java.util.Objects;

public abstract class TransactionAttribute
extends NeoSerializable {
    protected TransactionAttributeType type;

    public TransactionAttribute() {
    }

    public TransactionAttribute(TransactionAttributeType type) {
        if (type == null) {
            throw new IllegalArgumentException("Attribute type cannot be null.");
        }
        this.type = type;
    }

    public TransactionAttributeType getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return 1 + this.getSizeWithoutType();
    }

    protected abstract int getSizeWithoutType();

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            if (!TransactionAttributeType.valueOf(reader.readByte()).equals((Object)this.type)) {
                throw new DeserializationException("The deserialized type does not match the type information in the serialized data.");
            }
            this.deserializeWithoutType(reader);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    protected abstract void deserializeWithoutType(BinaryReader var1) throws DeserializationException, IOException;

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.writeByte(this.type.byteValue());
        this.serializeWithoutType(writer);
    }

    protected abstract void serializeWithoutType(BinaryWriter var1) throws IOException;

    public static TransactionAttribute deserializeAttribute(BinaryReader reader) throws DeserializationException {
        try {
            TransactionAttributeType type = TransactionAttributeType.valueOf(reader.readByte());
            TransactionAttribute a = type.clazz().newInstance();
            a.deserializeWithoutType(reader);
            return a;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new DeserializationException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionAttribute)) {
            return false;
        }
        TransactionAttribute that = (TransactionAttribute)o;
        return this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType()});
    }
}

