/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.transaction;

import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.Sign;
import io.neow3j.script.InvocationScript;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.script.VerificationScript;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.types.ContractParameter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class Witness
extends NeoSerializable {
    private InvocationScript invocationScript;
    private VerificationScript verificationScript;

    public Witness() {
        this.invocationScript = new InvocationScript();
        this.verificationScript = new VerificationScript();
    }

    public Witness(byte[] invocationScript, byte[] verificationScript) {
        this(new InvocationScript(invocationScript), new VerificationScript(verificationScript));
    }

    public Witness(InvocationScript invocationScript, VerificationScript verificationScript) {
        this.invocationScript = invocationScript;
        this.verificationScript = verificationScript;
    }

    public static Witness create(byte[] messageToSign, ECKeyPair keyPair) {
        InvocationScript i = InvocationScript.fromMessageAndKeyPair(messageToSign, keyPair);
        VerificationScript v = new VerificationScript(keyPair.getPublicKey());
        return new Witness(i, v);
    }

    public static Witness createMultiSigWitness(int signingThreshold, List<Sign.SignatureData> signatures, List<ECKeyPair.ECPublicKey> publicKeys) {
        VerificationScript v = new VerificationScript(publicKeys, signingThreshold);
        return Witness.createMultiSigWitness(signatures, v);
    }

    public static Witness createMultiSigWitness(List<Sign.SignatureData> signatures, VerificationScript verificationScript) {
        int signingThreshold = verificationScript.getSigningThreshold();
        if (signatures.size() < signingThreshold) {
            throw new IllegalArgumentException("Not enough signatures provided for the required signing threshold.");
        }
        return new Witness(InvocationScript.fromSignatures(signatures.subList(0, signingThreshold)), verificationScript);
    }

    public static Witness createContractWitness(List<ContractParameter> verifyParams) {
        if (verifyParams.isEmpty()) {
            return new Witness();
        }
        ScriptBuilder invocationScript = new ScriptBuilder();
        verifyParams.forEach(invocationScript::pushParam);
        return new Witness(invocationScript.toArray(), new byte[0]);
    }

    public InvocationScript getInvocationScript() {
        return this.invocationScript;
    }

    public VerificationScript getVerificationScript() {
        return this.verificationScript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Witness)) {
            return false;
        }
        Witness script = (Witness)o;
        return Objects.equals(this.getInvocationScript(), script.getInvocationScript()) && Objects.equals(this.getVerificationScript(), script.getVerificationScript());
    }

    public int hashCode() {
        return Objects.hash(this.getInvocationScript(), this.getVerificationScript());
    }

    public String toString() {
        return "Script{invocationScript='" + this.invocationScript + '\'' + ", verificationScript='" + this.verificationScript + '\'' + '}';
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        this.invocationScript = reader.readSerializable(InvocationScript.class);
        this.verificationScript = reader.readSerializable(VerificationScript.class);
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        this.invocationScript.serialize(writer);
        this.verificationScript.serialize(writer);
    }

    @Override
    public int getSize() {
        return this.invocationScript.getSize() + this.verificationScript.getSize();
    }
}

