/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.types;

public enum CallFlags {
    NONE(0),
    READ_STATES(1),
    WRITE_STATES(2),
    ALLOW_CALL(4),
    ALLOW_NOTIFY(8),
    STATES(CallFlags.READ_STATES.value | CallFlags.WRITE_STATES.value),
    READ_ONLY(CallFlags.READ_STATES.value | CallFlags.ALLOW_CALL.value),
    ALL(CallFlags.STATES.value | CallFlags.ALLOW_CALL.value | CallFlags.ALLOW_NOTIFY.value);

    private final byte value;

    private CallFlags(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public static CallFlags valueOf(byte value) {
        for (CallFlags e : CallFlags.values()) {
            if (e.value != value) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("There exists no call flag with the provided byte value (%d)", value));
    }
}

