/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.neow3j.crypto.Base64;
import io.neow3j.types.ContractParameterType;
import io.neow3j.types.Hash160;
import io.neow3j.types.Hash256;
import io.neow3j.utils.Numeric;
import io.neow3j.wallet.Account;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonSerialize(using=ContractParameterSerializer.class)
public class ContractParameter {
    @JsonProperty(value="name")
    private String paramName;
    @JsonProperty(value="type")
    private ContractParameterType paramType;
    @JsonProperty(value="value")
    protected Object value;

    private ContractParameter() {
    }

    protected ContractParameter(String name, ContractParameterType paramType, Object value) {
        this.paramName = name;
        this.paramType = paramType;
        this.value = value;
    }

    public ContractParameter(String name, ContractParameterType paramType) {
        this(name, paramType, null);
    }

    protected ContractParameter(ContractParameterType paramType, Object value) {
        this(null, paramType, value);
    }

    public static ContractParameter any(Object value) {
        return new ContractParameter(ContractParameterType.ANY, value);
    }

    public static ContractParameter string(String value) {
        return new ContractParameter(ContractParameterType.STRING, value);
    }

    public static ContractParameter array(Object ... entries) {
        if (entries.length == 0) {
            throw new IllegalArgumentException("At least one parameter is required to create an array contract parameter.");
        }
        if (Arrays.stream(entries).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Cannot add a null object to an array contract parameter.");
        }
        ContractParameter[] params = (ContractParameter[])Arrays.stream(entries).map(ContractParameter::castToContractParameter).toArray(ContractParameter[]::new);
        return new ContractParameter(ContractParameterType.ARRAY, params);
    }

    public static ContractParameter array(List<?> entries) {
        return ContractParameter.array(entries.toArray());
    }

    public static ContractParameter map(Map<?, ?> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("At least one map entry is required to create a map contract parameter.");
        }
        HashMap paramMap = new HashMap();
        map.forEach((k, v) -> {
            ContractParameter key = ContractParameter.castToContractParameter(k);
            ContractParameter value = ContractParameter.castToContractParameter(v);
            if (key.getParamType().equals((Object)ContractParameterType.ARRAY) || key.getParamType().equals((Object)ContractParameterType.MAP)) {
                throw new IllegalArgumentException("The provided map contains an invalid key. The keys cannot be of type array or map.");
            }
            paramMap.put(key, value);
        });
        return new ContractParameter(ContractParameterType.MAP, paramMap);
    }

    private static ContractParameter castToContractParameter(Object o) {
        if (o instanceof ContractParameter) {
            return (ContractParameter)o;
        }
        if (o instanceof Boolean) {
            return ContractParameter.bool((Boolean)o);
        }
        if (o instanceof Integer) {
            return ContractParameter.integer((Integer)o);
        }
        if (o instanceof Long) {
            return ContractParameter.integer(BigInteger.valueOf((Long)o));
        }
        if (o instanceof BigInteger) {
            return ContractParameter.integer((BigInteger)o);
        }
        if (o instanceof byte[]) {
            return ContractParameter.byteArray((byte[])o);
        }
        if (o instanceof String) {
            return ContractParameter.string((String)o);
        }
        if (o instanceof Hash160) {
            return ContractParameter.hash160((Hash160)o);
        }
        if (o instanceof Hash256) {
            return ContractParameter.hash256((Hash256)o);
        }
        if (o instanceof Account) {
            return ContractParameter.hash160((Account)o);
        }
        throw new IllegalArgumentException("The provided object could not be casted into a supported contract parameter type.");
    }

    public static ContractParameter byteArray(byte[] byteArray) {
        return new ContractParameter(ContractParameterType.BYTE_ARRAY, byteArray);
    }

    public static ContractParameter byteArray(String hexString) {
        if (!Numeric.isValidHexString(hexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number.");
        }
        return ContractParameter.byteArray(Numeric.hexStringToByteArray(hexString));
    }

    public static ContractParameter byteArrayFromString(String value) {
        return ContractParameter.byteArray(value.getBytes(StandardCharsets.UTF_8));
    }

    public static ContractParameter signature(String signatureHexString) {
        if (!Numeric.isValidHexString(signatureHexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number.");
        }
        return ContractParameter.signature(Numeric.hexStringToByteArray(signatureHexString));
    }

    public static ContractParameter signature(byte[] signature) {
        if (signature.length != 64) {
            throw new IllegalArgumentException("Signature is expected to have a length of 64 bytes, but had " + signature.length + ".");
        }
        return new ContractParameter(ContractParameterType.SIGNATURE, signature);
    }

    public static ContractParameter bool(boolean bool) {
        return new ContractParameter(ContractParameterType.BOOLEAN, bool);
    }

    public static ContractParameter integer(int integer) {
        return ContractParameter.integer(BigInteger.valueOf(integer));
    }

    public static ContractParameter integer(BigInteger integer) {
        return new ContractParameter(ContractParameterType.INTEGER, integer);
    }

    public static ContractParameter hash160(Account account) {
        return ContractParameter.hash160(account.getScriptHash());
    }

    public static ContractParameter hash160(Hash160 hash) {
        if (hash == null) {
            throw new IllegalArgumentException("The script hash argument must not be null.");
        }
        return new ContractParameter(ContractParameterType.HASH160, hash);
    }

    public static ContractParameter hash256(String hashHexString) {
        if (!Numeric.isValidHexString(hashHexString)) {
            throw new IllegalArgumentException("Argument is not a valid hex number.");
        }
        return ContractParameter.hash256(Numeric.hexStringToByteArray(hashHexString));
    }

    public static ContractParameter hash256(Hash256 hash) {
        return new ContractParameter(ContractParameterType.HASH256, hash);
    }

    public static ContractParameter hash256(byte[] hash) {
        if (hash.length != 32) {
            throw new IllegalArgumentException("A Hash256 parameter must be 32 bytes but was " + hash.length + " bytes.");
        }
        return ContractParameter.hash256(new Hash256(hash));
    }

    public static ContractParameter publicKey(String publicKey) {
        return ContractParameter.publicKey(Numeric.hexStringToByteArray(publicKey));
    }

    public static ContractParameter publicKey(byte[] publicKey) {
        if (publicKey.length != 33) {
            throw new IllegalArgumentException("Public key argument must be 33 bytes but was " + publicKey.length + " bytes.");
        }
        return new ContractParameter(ContractParameterType.PUBLIC_KEY, publicKey);
    }

    public String getParamName() {
        return this.paramName;
    }

    public ContractParameterType getParamType() {
        return this.paramType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractParameter)) {
            return false;
        }
        ContractParameter that = (ContractParameter)o;
        if (this.paramType == that.paramType && Objects.equals(this.paramName, that.paramName)) {
            if (this.paramType.equals((Object)ContractParameterType.BYTE_ARRAY) || this.paramType.equals((Object)ContractParameterType.SIGNATURE) || this.paramType.equals((Object)ContractParameterType.PUBLIC_KEY) || this.paramType.equals((Object)ContractParameterType.HASH160) || this.paramType.equals((Object)ContractParameterType.HASH256)) {
                return Arrays.equals((byte[])this.value, (byte[])that.value);
            }
            if (this.paramType.equals((Object)ContractParameterType.ARRAY)) {
                Object[] thatValue = (ContractParameter[])that.getValue();
                Object[] oValue = (ContractParameter[])((ContractParameter)o).getValue();
                return Arrays.equals(oValue, thatValue);
            }
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paramName, this.paramType, this.value});
    }

    protected static class ContractParameterSerializer
    extends StdSerializer<ContractParameter> {
        public ContractParameterSerializer() {
            this(null);
        }

        public ContractParameterSerializer(Class<ContractParameter> vc) {
            super(vc);
        }

        public void serialize(ContractParameter value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            this.serializeParameter(value, gen);
            gen.writeEndObject();
        }

        private void serializeParameter(ContractParameter p, JsonGenerator gen) throws IOException {
            if (p.getParamName() != null) {
                gen.writeStringField("name", p.getParamName());
            }
            if (p.getParamType() != null) {
                gen.writeStringField("type", p.getParamType().jsonValue());
            }
            if (p.getValue() != null) {
                this.serializeValue(p, gen);
            }
        }

        private void serializeValue(ContractParameter p, JsonGenerator gen) throws IOException {
            switch (p.getParamType()) {
                case SIGNATURE: 
                case PUBLIC_KEY: {
                    gen.writeStringField("value", Numeric.toHexStringNoPrefix((byte[])p.getValue()));
                    break;
                }
                case BYTE_ARRAY: {
                    gen.writeStringField("value", Base64.encode((byte[])p.getValue()));
                    break;
                }
                case BOOLEAN: {
                    gen.writeBooleanField("value", ((Boolean)p.getValue()).booleanValue());
                    break;
                }
                case INTEGER: 
                case HASH256: 
                case HASH160: 
                case INTEROP_INTERFACE: 
                case STRING: {
                    gen.writeStringField("value", p.getValue().toString());
                    break;
                }
                case ARRAY: {
                    gen.writeArrayFieldStart("value");
                    for (ContractParameter param : (ContractParameter[])p.getValue()) {
                        gen.writeStartObject();
                        this.serializeParameter(param, gen);
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                    break;
                }
                case MAP: {
                    gen.writeArrayFieldStart("value");
                    HashMap map = (HashMap)p.getValue();
                    for (ContractParameter key : map.keySet()) {
                        gen.writeStartObject();
                        gen.writeFieldName("key");
                        gen.writeStartObject();
                        this.serializeParameter(key, gen);
                        gen.writeEndObject();
                        gen.writeFieldName("value");
                        gen.writeStartObject();
                        this.serializeParameter((ContractParameter)map.get(key), gen);
                        gen.writeEndObject();
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Parameter type '" + p.getParamType().toString() + "' not supported.");
                }
            }
        }
    }
}

