/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.types;

import com.fasterxml.jackson.annotation.JsonValue;
import io.neow3j.crypto.Hash;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.utils.AddressUtils;
import io.neow3j.utils.ArrayUtils;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class Hash160
extends NeoSerializable
implements Comparable<Hash160> {
    private byte[] hash;
    public static final Hash160 ZERO = new Hash160("0000000000000000000000000000000000000000");

    public Hash160() {
        this.hash = new byte[20];
    }

    public Hash160(byte[] hash) {
        this.checkAndThrowHashLength(hash);
        this.hash = hash;
    }

    public Hash160(String hash) {
        if (!Numeric.isValidHexString(hash)) {
            throw new IllegalArgumentException("String argument is not hexadecimal.");
        }
        this.hash = Numeric.hexStringToByteArray(hash);
        this.checkAndThrowHashLength(this.hash);
    }

    @Override
    public void deserialize(BinaryReader reader) throws DeserializationException {
        try {
            this.hash = ArrayUtils.reverseArray(reader.readBytes(20));
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void serialize(BinaryWriter writer) throws IOException {
        writer.write(ArrayUtils.reverseArray(this.hash));
    }

    @Override
    public int getSize() {
        return 20;
    }

    @Override
    public byte[] toArray() {
        return this.hash;
    }

    public byte[] toLittleEndianArray() {
        return ArrayUtils.reverseArray(this.hash);
    }

    @JsonValue
    public String toString() {
        return Numeric.toHexStringNoPrefix(this.hash);
    }

    public String toAddress() {
        return AddressUtils.scriptHashToAddress(this.hash);
    }

    public static Hash160 fromAddress(String address) {
        return new Hash160(AddressUtils.addressToScriptHash(address));
    }

    public static Hash160 fromScript(byte[] script) {
        return new Hash160(ArrayUtils.reverseArray(Hash.sha256AndThenRipemd160(script)));
    }

    public static Hash160 fromPublicKey(byte[] encodedPublicKey) {
        return Hash160.fromScript(ScriptBuilder.buildVerificationScript(encodedPublicKey));
    }

    public static Hash160 fromPublicKeys(List<byte[]> encodedPublicKeys, int signingThreshold) {
        return Hash160.fromScript(ScriptBuilder.buildVerificationScript(encodedPublicKeys, signingThreshold));
    }

    public static Hash160 fromScript(String script) {
        return Hash160.fromScript(Numeric.hexStringToByteArray(script));
    }

    private void checkAndThrowHashLength(byte[] hash) {
        if (hash.length != 20) {
            throw new IllegalArgumentException("Hash must be 20 bytes long but was " + hash.length + " bytes.");
        }
    }

    @Override
    public int compareTo(Hash160 o) {
        return new BigInteger(1, this.hash).compareTo(new BigInteger(1, o.toArray()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash160 that = (Hash160)o;
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }
}

