/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.wallet;

import io.neow3j.crypto.Base64;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.NEP2;
import io.neow3j.crypto.ScryptParams;
import io.neow3j.crypto.WIF;
import io.neow3j.crypto.exceptions.CipherException;
import io.neow3j.crypto.exceptions.NEP2InvalidFormat;
import io.neow3j.crypto.exceptions.NEP2InvalidPassphrase;
import io.neow3j.protocol.Neow3j;
import io.neow3j.protocol.core.response.NeoGetNep17Balances;
import io.neow3j.script.VerificationScript;
import io.neow3j.types.ContractParameterType;
import io.neow3j.types.Hash160;
import io.neow3j.utils.AddressUtils;
import io.neow3j.utils.Numeric;
import io.neow3j.wallet.Wallet;
import io.neow3j.wallet.exceptions.AccountStateException;
import io.neow3j.wallet.nep6.NEP6Account;
import io.neow3j.wallet.nep6.NEP6Contract;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class Account {
    private ECKeyPair keyPair;
    private String address;
    private String encryptedPrivateKey;
    private String label;
    private boolean isLocked;
    private VerificationScript verificationScript;
    private Wallet wallet;

    protected Account() {
    }

    public Account(ECKeyPair ecKeyPair) {
        this.keyPair = ecKeyPair;
        this.label = this.address = ecKeyPair.getAddress();
        this.verificationScript = new VerificationScript(ecKeyPair.getPublicKey());
    }

    public String getAddress() {
        return this.address;
    }

    public Hash160 getScriptHash() {
        return Hash160.fromAddress(this.address);
    }

    public ECKeyPair getECKeyPair() {
        return this.keyPair;
    }

    public String getLabel() {
        return this.label;
    }

    public Account label(String label) {
        this.label = label;
        return this;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public Boolean isDefault() {
        if (this.wallet == null) {
            return false;
        }
        return this.wallet.isDefault(this.getScriptHash());
    }

    public Boolean isLocked() {
        return this.isLocked;
    }

    public Account lock() {
        this.isLocked = true;
        return this;
    }

    public void unlock() {
        this.isLocked = false;
    }

    void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public VerificationScript getVerificationScript() {
        return this.verificationScript;
    }

    public String getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public void decryptPrivateKey(String password) throws NEP2InvalidFormat, CipherException, NEP2InvalidPassphrase {
        this.decryptPrivateKey(password, NEP2.DEFAULT_SCRYPT_PARAMS);
    }

    public void decryptPrivateKey(String password, ScryptParams scryptParams) throws NEP2InvalidFormat, CipherException, NEP2InvalidPassphrase {
        if (this.keyPair != null) {
            return;
        }
        if (this.encryptedPrivateKey == null) {
            throw new AccountStateException("The account does not hold an encrypted private key.");
        }
        this.keyPair = NEP2.decrypt(password, this.encryptedPrivateKey, scryptParams);
    }

    public void encryptPrivateKey(String password) throws CipherException {
        this.encryptPrivateKey(password, NEP2.DEFAULT_SCRYPT_PARAMS);
    }

    public void encryptPrivateKey(String password, ScryptParams scryptParams) throws CipherException {
        if (this.keyPair == null) {
            throw new AccountStateException("The account does not hold a decrypted private key.");
        }
        this.encryptedPrivateKey = NEP2.encrypt(password, this.keyPair, scryptParams);
        this.keyPair.getPrivateKey().erase();
        this.keyPair = null;
    }

    public boolean isMultiSig() {
        if (this.verificationScript == null) {
            throw new AccountStateException("The account with script hash " + this.getScriptHash() + " does not have a verification script.");
        }
        return this.verificationScript.isMultiSigScript();
    }

    public Map<Hash160, BigInteger> getNep17Balances(Neow3j neow3j) throws IOException {
        NeoGetNep17Balances result = neow3j.getNep17Balances(this.getScriptHash()).send();
        HashMap<Hash160, BigInteger> balances = new HashMap<Hash160, BigInteger>();
        result.getBalances().getBalances().forEach(b -> balances.put(b.getAssetHash(), new BigInteger(b.getAmount())));
        return balances;
    }

    public NEP6Account toNEP6Account() {
        if (this.keyPair != null && this.encryptedPrivateKey == null) {
            throw new AccountStateException("Account private key is available but not encrypted.");
        }
        if (this.verificationScript == null) {
            return new NEP6Account(this.address, this.label, this.isDefault(), this.isLocked, this.encryptedPrivateKey, null, null);
        }
        ArrayList<NEP6Contract.NEP6Parameter> parameters = new ArrayList<NEP6Contract.NEP6Parameter>();
        if (this.verificationScript.isMultiSigScript()) {
            IntStream.range(0, this.verificationScript.getNrOfAccounts()).forEachOrdered(i -> parameters.add(new NEP6Contract.NEP6Parameter("signature" + i, ContractParameterType.SIGNATURE)));
        } else if (this.verificationScript.isSingleSigScript()) {
            parameters.add(new NEP6Contract.NEP6Parameter("signature", ContractParameterType.SIGNATURE));
        }
        String script = Base64.encode(this.verificationScript.getScript());
        NEP6Contract contract = new NEP6Contract(script, parameters, false);
        return new NEP6Account(this.address, this.label, this.isDefault(), this.isLocked, this.encryptedPrivateKey, contract, null);
    }

    public static Account fromVerificationScript(VerificationScript script) {
        String address = Hash160.fromScript(script.getScript()).toAddress();
        Account account = new Account();
        account.address = address;
        account.label = address;
        account.verificationScript = script;
        return account;
    }

    public static Account fromPublicKey(ECKeyPair.ECPublicKey publicKey) {
        VerificationScript script = new VerificationScript(publicKey);
        String address = Hash160.fromScript(script.getScript()).toAddress();
        Account account = new Account();
        account.address = address;
        account.label = address;
        account.verificationScript = script;
        return account;
    }

    public static Account createMultiSigAccount(List<ECKeyPair.ECPublicKey> publicKeys, int signatureThreshold) {
        VerificationScript script = new VerificationScript(publicKeys, signatureThreshold);
        String address = Hash160.fromScript(script.getScript()).toAddress();
        Account account = new Account();
        account.address = address;
        account.label = address;
        account.verificationScript = script;
        return account;
    }

    public static Account fromWIF(String wif) {
        BigInteger privateKey = Numeric.toBigInt(WIF.getPrivateKeyFromWIF(wif));
        ECKeyPair keyPair = ECKeyPair.create(privateKey);
        Account account = new Account();
        account.keyPair = keyPair;
        account.address = keyPair.getAddress();
        account.label = keyPair.getAddress();
        account.verificationScript = new VerificationScript(keyPair.getPublicKey());
        return account;
    }

    public static Account fromNewECKeyPair() {
        try {
            return new Account(ECKeyPair.createEcKeyPair());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("Failed to create a new EC key pair.", e);
        }
    }

    public static Account fromNEP6Account(NEP6Account nep6Acct) {
        Account account = new Account();
        account.address = nep6Acct.getAddress();
        account.label = nep6Acct.getLabel();
        account.encryptedPrivateKey = nep6Acct.getKey();
        account.isLocked = nep6Acct.getLock();
        NEP6Contract contr = nep6Acct.getContract();
        if (contr != null && contr.getScript() != null && !contr.getScript().isEmpty()) {
            byte[] script = Base64.decode(contr.getScript());
            account.verificationScript = new VerificationScript(script);
        }
        return account;
    }

    public static Account fromAddress(String address) {
        if (!AddressUtils.isValidAddress(address)) {
            throw new IllegalArgumentException("Invalid address.");
        }
        Account account = new Account();
        account.address = address;
        account.label = address;
        return account;
    }

    public static Account create() {
        return Account.fromNewECKeyPair();
    }
}

