/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.wallet;

import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.MnemonicUtils;
import io.neow3j.crypto.SecureRandomUtils;
import io.neow3j.wallet.Account;

public class Bip39Account
extends Account {
    private String mnemonic;

    private Bip39Account() {
    }

    protected Bip39Account(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    public Bip39Account(ECKeyPair ecKeyPair) {
        super(ecKeyPair);
    }

    private Bip39Account mnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
        return this;
    }

    public static Bip39Account create(String password) {
        byte[] initialEntropy = SecureRandomUtils.generateRandomBytes(16);
        String mnemonic = MnemonicUtils.generateMnemonic(initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        ECKeyPair keyPair = ECKeyPair.create(Hash.sha256(seed));
        return new Bip39Account(keyPair).mnemonic(mnemonic);
    }

    public static Bip39Account fromBip39Mnemonic(String password, String mnemonic) {
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        ECKeyPair ecKeyPair = ECKeyPair.create(Hash.sha256(seed));
        return new Bip39Account(ecKeyPair).mnemonic(mnemonic);
    }

    public String getMnemonic() {
        return this.mnemonic;
    }
}

