/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.wallet;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.NEP2;
import io.neow3j.crypto.ScryptParams;
import io.neow3j.crypto.SecurityProviderChecker;
import io.neow3j.crypto.exceptions.CipherException;
import io.neow3j.crypto.exceptions.NEP2InvalidFormat;
import io.neow3j.crypto.exceptions.NEP2InvalidPassphrase;
import io.neow3j.protocol.Neow3j;
import io.neow3j.script.VerificationScript;
import io.neow3j.types.Hash160;
import io.neow3j.wallet.Account;
import io.neow3j.wallet.nep6.NEP6Account;
import io.neow3j.wallet.nep6.NEP6Wallet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Wallet {
    private static final String DEFAULT_WALLET_NAME = "neow3jWallet";
    public static final String CURRENT_VERSION = "3.0";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String name = "neow3jWallet";
    private String version = "3.0";
    private Map<Hash160, Account> accounts = new HashMap<Hash160, Account>();
    private ScryptParams scryptParams = NEP2.DEFAULT_SCRYPT_PARAMS;
    private Hash160 defaultAccount;

    private Wallet() {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Account> getAccounts() {
        return this.accounts.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Wallet defaultAccount(Hash160 accountHash160) {
        if (accountHash160 == null) {
            throw new IllegalArgumentException("No account provided to set default.");
        }
        if (!this.accounts.containsKey(accountHash160)) {
            throw new IllegalArgumentException("Can't set default account on wallet. Wallet does not contain the account with script hash " + accountHash160.toString() + ".");
        }
        this.defaultAccount = accountHash160;
        return this;
    }

    public ScryptParams getScryptParams() {
        return this.scryptParams;
    }

    public Account getDefaultAccount() {
        return this.accounts.get(this.defaultAccount);
    }

    public Boolean isDefault(Account account) {
        return this.isDefault(account.getScriptHash());
    }

    public Boolean isDefault(Hash160 accountHash160) {
        return this.getDefaultAccount().getScriptHash().equals(accountHash160);
    }

    public Wallet name(String name) {
        this.name = name;
        return this;
    }

    public Wallet version(String version) {
        this.version = version;
        return this;
    }

    public Wallet scryptParams(ScryptParams scryptParams) {
        this.scryptParams = scryptParams;
        return this;
    }

    public Wallet addAccounts(Account ... accounts) {
        for (Account acct : accounts) {
            if (this.accounts.containsKey(acct.getScriptHash())) continue;
            if (acct.getWallet() != null) {
                throw new IllegalArgumentException("The account " + acct.getAddress() + " is already contained in a wallet. Please remove this account from its containing wallet before adding it to another wallet.");
            }
            this.accounts.put(acct.getScriptHash(), acct);
            acct.setWallet(this);
        }
        return this;
    }

    public boolean removeAccount(Account account) {
        return this.removeAccount(account.getScriptHash());
    }

    public boolean removeAccount(Hash160 hash160) {
        if (!this.accounts.containsKey(hash160)) {
            return false;
        }
        if (this.accounts.size() == 1) {
            throw new IllegalArgumentException("The account " + hash160.toAddress() + " is the only account in the wallet. It cannot be removed.");
        }
        this.accounts.get(hash160).setWallet(null);
        if (hash160.equals(this.getDefaultAccount().getScriptHash())) {
            Hash160 newDefaultAccountHash160 = (Hash160)((Map.Entry)this.accounts.entrySet().stream().filter(e -> !((Hash160)e.getKey()).equals(hash160)).iterator().next()).getKey();
            this.defaultAccount(newDefaultAccountHash160);
        }
        return this.accounts.remove(hash160) != null;
    }

    public void decryptAllAccounts(String password) throws NEP2InvalidFormat, CipherException, NEP2InvalidPassphrase {
        for (Map.Entry<Hash160, Account> e : this.accounts.entrySet()) {
            e.getValue().decryptPrivateKey(password, this.scryptParams);
        }
    }

    public void encryptAllAccounts(String password) throws CipherException {
        for (Map.Entry<Hash160, Account> e : this.accounts.entrySet()) {
            e.getValue().encryptPrivateKey(password, this.scryptParams);
        }
    }

    public NEP6Wallet toNEP6Wallet() {
        List<NEP6Account> accts = this.accounts.values().stream().map(Account::toNEP6Account).collect(Collectors.toList());
        return new NEP6Wallet(this.name, this.version, this.scryptParams, accts, null);
    }

    public static Wallet fromNEP6Wallet(String nep6WalletFileName) throws IOException {
        return Wallet.fromNEP6Wallet(Wallet.class.getClassLoader().getResourceAsStream(nep6WalletFileName));
    }

    public static Wallet fromNEP6Wallet(URI nep6WalletFileUri) throws IOException {
        return Wallet.fromNEP6Wallet(nep6WalletFileUri.toURL().openStream());
    }

    public static Wallet fromNEP6Wallet(File nep6WalletFile) throws IOException {
        return Wallet.fromNEP6Wallet(new FileInputStream(nep6WalletFile));
    }

    public static Wallet fromNEP6Wallet(InputStream nep6WalletFileInputStream) throws IOException {
        NEP6Wallet nep6Wallet = (NEP6Wallet)OBJECT_MAPPER.readValue(nep6WalletFileInputStream, NEP6Wallet.class);
        return Wallet.fromNEP6Wallet(nep6Wallet);
    }

    public static Wallet fromNEP6Wallet(NEP6Wallet nep6Wallet) {
        Account[] accs = (Account[])nep6Wallet.getAccounts().stream().map(Account::fromNEP6Account).toArray(Account[]::new);
        Optional<NEP6Account> defaultAccount = nep6Wallet.getAccounts().stream().filter(NEP6Account::getDefault).findFirst();
        if (defaultAccount.isPresent()) {
            Hash160 defaultAccountHash160 = Account.fromNEP6Account(defaultAccount.get()).getScriptHash();
            return new Wallet().name(nep6Wallet.getName()).version(nep6Wallet.getVersion()).scryptParams(nep6Wallet.getScrypt()).addAccounts(accs).defaultAccount(defaultAccountHash160);
        }
        throw new IllegalArgumentException("The Nep-6 wallet does not contain any default account.");
    }

    public Wallet saveNEP6Wallet(File destination) throws IOException {
        if (destination == null) {
            throw new IllegalArgumentException("Destination file cannot be null");
        }
        NEP6Wallet nep6Wallet = this.toNEP6Wallet();
        if (destination.isDirectory()) {
            String fileName = this.getName() + ".json";
            destination = Paths.get(destination.toString(), fileName).toFile();
        }
        OBJECT_MAPPER.writeValue(destination, (Object)nep6Wallet);
        return this;
    }

    public Map<Hash160, BigInteger> getNep17TokenBalances(Neow3j neow3j) throws IOException {
        HashMap<Hash160, BigInteger> balances = new HashMap<Hash160, BigInteger>();
        for (Account a : this.accounts.values()) {
            for (Map.Entry<Hash160, BigInteger> e : a.getNep17Balances(neow3j).entrySet()) {
                balances.merge(e.getKey(), e.getValue(), BigInteger::add);
            }
        }
        return balances;
    }

    public static Wallet create() {
        Account a = Account.fromNewECKeyPair();
        return new Wallet().addAccounts(a).defaultAccount(a.getScriptHash());
    }

    public static Wallet create(String password) throws CipherException {
        Wallet w = Wallet.create();
        w.encryptAllAccounts(password);
        return w;
    }

    public static Wallet create(String password, File destination) throws CipherException, IOException {
        Wallet wallet = Wallet.create(password);
        wallet.saveNEP6Wallet(destination);
        return wallet;
    }

    public static Wallet withAccounts(Account ... accounts) {
        if (accounts.length == 0) {
            throw new IllegalArgumentException("No accounts provided to initialize a wallet.");
        }
        return new Wallet().addAccounts(accounts).defaultAccount(accounts[0].getScriptHash());
    }

    public boolean holdsAccount(Hash160 hash160) {
        return this.accounts.containsKey(hash160);
    }

    public Account getAccount(Hash160 hash160) {
        return this.accounts.get(hash160);
    }

    public boolean privateKeysArePresentForMultiSig(VerificationScript multiSigVerificationScript) {
        int signers = 0;
        for (ECKeyPair.ECPublicKey pubKey : multiSigVerificationScript.getPublicKeys()) {
            Account account;
            Hash160 hash160 = Hash160.fromPublicKey(pubKey.getEncoded(true));
            if (!this.holdsAccount(hash160) || (account = this.getAccount(hash160)) == null || account.getECKeyPair() == null) continue;
            ++signers;
        }
        int signingThreshold = multiSigVerificationScript.getSigningThreshold();
        return signers >= signingThreshold;
    }

    static {
        SecurityProviderChecker.addBouncyCastle();
    }
}

