/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.constants;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;

public class NeoConstants {
    public static final int FIXED8_SCALE = 8;
    public static final BigDecimal FIXED8_DECIMALS = BigDecimal.TEN.pow(8);
    public static final int FIXED8_LENGTH = 8;
    public static final int MAX_PUBLIC_KEYS_PER_MULTISIG_ACCOUNT = 1024;
    public static final int HASH160_SIZE = 20;
    public static final int HASH256_SIZE = 32;
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 33;
    public static final int SIGNATURE_SIZE = 64;
    public static final int VERIFICATION_SCRIPT_SIZE = 40;
    public static final byte CURRENT_TX_VERSION = 0;
    public static final int MAX_TRANSACTION_SIZE = 102400;
    public static final int MAX_TRANSACTION_ATTRIBUTES = 16;
    public static final int MAX_SIGNER_SUBITEMS = 16;
    public static final int MAX_MANIFEST_SIZE = 65535;

    public static ECDomainParameters secp256r1DomainParams() {
        return new ECDomainParameters(NeoConstants.secp256r1CurveParams().getCurve(), NeoConstants.secp256r1CurveParams().getG(), NeoConstants.secp256r1CurveParams().getN(), NeoConstants.secp256r1CurveParams().getH());
    }

    public static X9ECParameters secp256r1CurveParams() {
        return CustomNamedCurves.getByName((String)"secp256r1");
    }

    public static BigInteger secp256r1HalfCurveOrder() {
        return NeoConstants.secp256r1CurveParams().getN().shiftRight(1);
    }
}

