/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.constants.NeoConstants;
import io.neow3j.crypto.ECKeyPair;
import io.neow3j.crypto.Hash;
import io.neow3j.crypto.Sign;
import io.neow3j.utils.Numeric;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.math.ec.ECPoint;

public class Bip32ECKeyPair
extends ECKeyPair {
    public static final int HARDENED_BIT = Integer.MIN_VALUE;
    private final boolean parentHasPrivate;
    private final int childNumber;
    private final int depth;
    private final byte[] chainCode;
    private int parentFingerprint;
    private ECPoint publicKeyPoint;

    public Bip32ECKeyPair(ECKeyPair.ECPrivateKey privateKey, ECKeyPair.ECPublicKey publicKey, int childNumber, byte[] chainCode, Bip32ECKeyPair parent) {
        super(privateKey, publicKey);
        this.parentHasPrivate = parent != null && parent.hasPrivateKey();
        this.childNumber = childNumber;
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.chainCode = Arrays.copyOf(chainCode, chainCode.length);
        this.parentFingerprint = parent != null ? parent.getFingerprint() : 0;
    }

    public static Bip32ECKeyPair create(ECKeyPair.ECPrivateKey privateKey, byte[] chainCode) {
        return Bip32ECKeyPair.create(privateKey.getInt(), chainCode);
    }

    public static Bip32ECKeyPair create(BigInteger privateKey, byte[] chainCode) {
        ECKeyPair.ECPrivateKey ecPrivateKey = new ECKeyPair.ECPrivateKey(privateKey);
        return new Bip32ECKeyPair(ecPrivateKey, Sign.publicKeyFromPrivate(ecPrivateKey), 0, chainCode, null);
    }

    public static Bip32ECKeyPair create(byte[] privateKey, byte[] chainCode) {
        return Bip32ECKeyPair.create(Numeric.toBigInt(privateKey), chainCode);
    }

    public static Bip32ECKeyPair generateKeyPair(byte[] seed) {
        byte[] i = Hash.hmacSha512("Bitcoin seed".getBytes(), seed);
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] ir = Arrays.copyOfRange(i, 32, 64);
        Arrays.fill(i, (byte)0);
        Bip32ECKeyPair keypair = Bip32ECKeyPair.create(il, ir);
        Arrays.fill(il, (byte)0);
        Arrays.fill(ir, (byte)0);
        return keypair;
    }

    public static Bip32ECKeyPair deriveKeyPair(Bip32ECKeyPair master, int[] path) {
        Bip32ECKeyPair curr = master;
        if (path != null) {
            for (int childNumber : path) {
                curr = curr.deriveChildKey(childNumber);
            }
        }
        return curr;
    }

    private static byte[] bigIntegerToBytes32(BigInteger b) {
        int numBytes = 32;
        byte[] src = b.toByteArray();
        byte[] dest = new byte[32];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = 32 - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    private static boolean isHardened(int a) {
        return (a & Integer.MIN_VALUE) != 0;
    }

    private Bip32ECKeyPair deriveChildKey(int childNumber) {
        if (!this.hasPrivateKey()) {
            byte[] parentPublicKey = this.getPublicKeyPoint().getEncoded(true);
            ByteBuffer data = ByteBuffer.allocate(37);
            data.put(parentPublicKey);
            data.putInt(childNumber);
            byte[] i = Hash.hmacSha512(this.getChainCode(), data.array());
            byte[] il = Arrays.copyOfRange(i, 0, 32);
            byte[] chainCode = Arrays.copyOfRange(i, 32, 64);
            Arrays.fill(i, (byte)0);
            BigInteger ilInt = new BigInteger(1, il);
            Arrays.fill(il, (byte)0);
            ECPoint ki = Sign.publicPointFromPrivateKey(new ECKeyPair.ECPrivateKey(ilInt)).add(this.getPublicKeyPoint());
            byte[] bytesPrivKeyEncoded = ki.getEncoded(true);
            ECKeyPair.ECPublicKey ecPublicKey = Sign.publicKeyFromPrivate(new ECKeyPair.ECPrivateKey(bytesPrivKeyEncoded));
            return new Bip32ECKeyPair(null, ecPublicKey, childNumber, chainCode, this);
        }
        ByteBuffer data = ByteBuffer.allocate(37);
        if (Bip32ECKeyPair.isHardened(childNumber)) {
            data.put(this.getPrivateKeyBytes33());
        } else {
            byte[] parentPublicKey = this.getPublicKeyPoint().getEncoded(true);
            data.put(parentPublicKey);
        }
        data.putInt(childNumber);
        byte[] i = Hash.hmacSha512(this.getChainCode(), data.array());
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] chainCode = Arrays.copyOfRange(i, 32, 64);
        Arrays.fill(i, (byte)0);
        BigInteger ilInt = new BigInteger(1, il);
        Arrays.fill(il, (byte)0);
        BigInteger privateKey = this.getPrivateKey().getInt().add(ilInt).mod(NeoConstants.secp256r1DomainParams().getN());
        ECKeyPair.ECPrivateKey ecPrivateKey = new ECKeyPair.ECPrivateKey(privateKey);
        ECKeyPair.ECPublicKey ecPublicKey = Sign.publicKeyFromPrivate(ecPrivateKey);
        return new Bip32ECKeyPair(ecPrivateKey, ecPublicKey, childNumber, chainCode, this);
    }

    private int getFingerprint() {
        byte[] id = this.getIdentifier();
        return id[3] & 0xFF | (id[2] & 0xFF) << 8 | (id[1] & 0xFF) << 16 | (id[0] & 0xFF) << 24;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getParentFingerprint() {
        return this.parentFingerprint;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public int getChildNumber() {
        return this.childNumber;
    }

    private byte[] getIdentifier() {
        return Hash.sha256AndThenRipemd160(this.getPublicKeyPoint().getEncoded(true));
    }

    public ECPoint getPublicKeyPoint() {
        if (this.publicKeyPoint == null) {
            this.publicKeyPoint = Sign.publicPointFromPrivateKey(this.getPrivateKey());
        }
        return this.publicKeyPoint;
    }

    public byte[] getPrivateKeyBytes33() {
        int numBytes = 33;
        byte[] bytes33 = new byte[33];
        byte[] priv = Bip32ECKeyPair.bigIntegerToBytes32(this.getPrivateKey().getInt());
        System.arraycopy(priv, 0, bytes33, 33 - priv.length, priv.length);
        return bytes33;
    }

    private boolean hasPrivateKey() {
        return this.getPrivateKey() != null || this.parentHasPrivate;
    }
}

