/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.constants.NeoConstants;
import java.math.BigInteger;

public class ECDSASignature {
    public final BigInteger r;
    public final BigInteger s;

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public boolean isCanonical() {
        return this.s.compareTo(NeoConstants.secp256r1HalfCurveOrder()) <= 0;
    }

    public ECDSASignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new ECDSASignature(this.r, NeoConstants.secp256r1DomainParams().getN().subtract(this.s));
        }
        return this;
    }
}

