/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.crypto;

import io.neow3j.constants.NeoConstants;
import io.neow3j.crypto.ECDSASignature;
import io.neow3j.crypto.SecureRandomUtils;
import io.neow3j.crypto.SecurityProviderChecker;
import io.neow3j.crypto.Sign;
import io.neow3j.crypto.WIF;
import io.neow3j.script.ScriptBuilder;
import io.neow3j.serialization.BinaryReader;
import io.neow3j.serialization.BinaryWriter;
import io.neow3j.serialization.NeoSerializable;
import io.neow3j.serialization.exceptions.DeserializationException;
import io.neow3j.types.Hash160;
import io.neow3j.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ECKeyPair {
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;

    public ECKeyPair(ECPrivateKey privateKey, ECPublicKey publicKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("A ECKeyPair cannot be created without a private key.");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getAddress() {
        return this.getScriptHash().toAddress();
    }

    public Hash160 getScriptHash() {
        byte[] script = ScriptBuilder.buildVerificationScript(this.publicKey.getEncoded(true));
        return Hash160.fromScript(script);
    }

    public BigInteger[] sign(byte[] messageHash) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.privateKey.getInt(), NeoConstants.secp256r1DomainParams());
        signer.init(true, (CipherParameters)privKey);
        return signer.generateSignature(messageHash);
    }

    public ECDSASignature signAndGetECDSASignature(byte[] messageHash) {
        BigInteger[] components = this.sign(messageHash);
        return new ECDSASignature(components[0], components[1]);
    }

    public byte[] signAndGetArrayBytes(byte[] messageHash) {
        BigInteger[] components = this.sign(messageHash);
        byte[] signature = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)components[0]), 0, signature, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)components[1]), 0, signature, 32, 32);
        return signature;
    }

    public static ECKeyPair create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        return new ECKeyPair(new ECPrivateKey(privateKey.getD()), new ECPublicKey(publicKey.getQ()));
    }

    public static ECKeyPair create(ECPrivateKey privateKey) {
        return new ECKeyPair(privateKey, Sign.publicKeyFromPrivate(privateKey));
    }

    public static ECKeyPair create(BigInteger privateKey) {
        return ECKeyPair.create(new ECPrivateKey(privateKey));
    }

    public static ECKeyPair create(byte[] privateKey) {
        return ECKeyPair.create(new ECPrivateKey(privateKey));
    }

    public static ECKeyPair createEcKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = ECKeyPair.createSecp256r1KeyPair();
        return ECKeyPair.create(keyPair);
    }

    private static KeyPair createSecp256r1KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256r1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public String exportAsWIF() {
        return WIF.getWIFFromPrivateKey(this.getPrivateKey().getBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair that = (ECKeyPair)o;
        return Objects.equals(this.privateKey, that.privateKey) && Objects.equals(this.publicKey, that.publicKey);
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }

    static {
        SecurityProviderChecker.addBouncyCastle();
    }

    public static class ECPublicKey
    extends NeoSerializable {
        private ECPoint ecPoint;

        public ECPublicKey() {
        }

        public ECPublicKey(String publicKey) {
            this(Numeric.hexStringToByteArray(publicKey));
        }

        public ECPublicKey(ECPoint ecPoint) {
            if (!ecPoint.getCurve().equals(NeoConstants.secp256r1CurveParams().getCurve())) {
                throw new IllegalArgumentException("Given EC point is not of the required curve.");
            }
            this.ecPoint = ecPoint;
        }

        public ECPublicKey(byte[] publicKey) {
            if (publicKey.length != 33) {
                throw new IllegalArgumentException("Public key argument must be 33 long but was " + publicKey.length + " bytes");
            }
            this.ecPoint = NeoConstants.secp256r1CurveParams().getCurve().decodePoint(publicKey);
        }

        public ECPublicKey(BigInteger publicKey) {
            this(Numeric.toBytesPadded(publicKey, 33));
        }

        public byte[] getEncoded(boolean compressed) {
            return this.ecPoint.getEncoded(compressed);
        }

        public ECPoint getECPoint() {
            return this.ecPoint;
        }

        @Override
        public void deserialize(BinaryReader reader) throws DeserializationException {
            try {
                this.ecPoint = NeoConstants.secp256r1CurveParams().getCurve().decodePoint(reader.readBytes(33));
            }
            catch (IOException e) {
                throw new DeserializationException();
            }
        }

        @Override
        public void serialize(BinaryWriter writer) throws IOException {
            writer.write(this.getEncoded(true));
        }

        @Override
        public int getSize() {
            return this.ecPoint.isInfinity() ? 1 : 33;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ECPublicKey that = (ECPublicKey)o;
            return Objects.equals(this.ecPoint, that.ecPoint);
        }

        public int hashCode() {
            return this.ecPoint.hashCode();
        }
    }

    public static class ECPrivateKey {
        private byte[] privateKey;

        public ECPrivateKey(BigInteger key) {
            if (key.toString(16).length() > 64) {
                throw new IllegalArgumentException("Private key must fit into32 bytes, but required " + key.toString(16).length() / 2 + "bytes.");
            }
            this.privateKey = Numeric.toBytesPadded(key, 32);
        }

        public ECPrivateKey(byte[] key) {
            if (key.length != 32) {
                throw new IllegalArgumentException("Private key byte array must have length of 32 but had length " + key.length);
            }
            this.privateKey = key;
        }

        public BigInteger getInt() {
            return new BigInteger(1, this.privateKey);
        }

        public byte[] getBytes() {
            return this.privateKey;
        }

        public void erase() {
            for (int i = 0; i < this.privateKey.length; ++i) {
                this.privateKey[i] = 0;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ECPrivateKey that = (ECPrivateKey)o;
            return Arrays.equals(this.privateKey, that.privateKey);
        }

        public int hashCode() {
            return Arrays.hashCode(this.privateKey);
        }
    }
}

