/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol;

import io.neow3j.utils.Async;
import java.util.concurrent.ScheduledExecutorService;

public class Neow3jConfig {
    public static final int DEFAULT_BLOCK_TIME = 15000;
    public static final byte DEFAULT_ADDRESS_VERSION = 53;
    public static final int MAX_VALID_UNTIL_BLOCK_INCREMENT_BASE = 86400000;
    private static byte addressVersion = (byte)53;
    private Long networkMagic = null;
    private int blockInterval = 15000;
    private long maxValidUntilBlockIncrement = 86400000 / this.blockInterval;
    private int pollingInterval = 15000;
    private ScheduledExecutorService scheduledExecutorService = Async.defaultExecutorService();

    public Neow3jConfig() {
    }

    public Neow3jConfig(long networkMagic, int blockInterval, int pollingInterval, long maxValidUntilBlockIncrement, ScheduledExecutorService scheduledExecutorService) {
        this.networkMagic = networkMagic;
        this.blockInterval = blockInterval;
        this.maxValidUntilBlockIncrement = maxValidUntilBlockIncrement;
        this.pollingInterval = pollingInterval;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public Neow3jConfig setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Neow3jConfig setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.scheduledExecutorService = executorService;
        return this;
    }

    public static byte getAddressVersion() {
        return addressVersion;
    }

    public static void setAddressVersion(byte version) {
        addressVersion = version;
    }

    public Long getNetworkMagic() {
        return this.networkMagic;
    }

    public Neow3jConfig setNetworkMagic(long magic) {
        if (magic > 0xFFFFFFFFL || magic < 0L) {
            throw new IllegalArgumentException("The network magic number must fit into a 32-bit unsigned integer, i.e., it must be positive and not greater than 0xFFFFFFFF.");
        }
        this.networkMagic = magic;
        return this;
    }

    public int getBlockInterval() {
        return this.blockInterval;
    }

    public Neow3jConfig setBlockInterval(int blockInterval) {
        this.blockInterval = blockInterval;
        return this;
    }

    public long getMaxValidUntilBlockIncrement() {
        return this.maxValidUntilBlockIncrement;
    }

    public Neow3jConfig setMaxValidUntilBlockIncrement(long maxValidUntilBlockIncrement) {
        this.maxValidUntilBlockIncrement = maxValidUntilBlockIncrement;
        return this;
    }
}

