/*
 * Decompiled with CFR 0.152.
 */
package io.neow3j.protocol.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum RecordType {
    A("A", 1),
    CNAME("CNAME", 5),
    TXT("TXT", 16),
    AAAA("AAAA", 28);

    private final String jsonValue;
    private final byte byteValue;

    private RecordType(String jsonValue, int byteValue) {
        this.jsonValue = jsonValue;
        this.byteValue = (byte)byteValue;
    }

    @JsonCreator
    public static RecordType fromJson(Object value) {
        if (value instanceof String) {
            return RecordType.fromJsonValue((String)value);
        }
        if (value instanceof Integer) {
            return RecordType.valueOf(((Integer)value).byteValue());
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", RecordType.class.getName()));
    }

    public static RecordType valueOf(byte byteValue) {
        for (RecordType e : RecordType.values()) {
            if (e.byteValue != byteValue) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", RecordType.class.getName()));
    }

    public static RecordType fromJsonValue(String jsonValue) {
        for (RecordType e : RecordType.values()) {
            if (!e.jsonValue.equals(jsonValue)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("%s value type not found.", RecordType.class.getName()));
    }

    public byte byteValue() {
        return this.byteValue;
    }

    @JsonValue
    public String jsonValue() {
        return this.jsonValue;
    }
}

